/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator;

import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlock;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.EndInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.Instruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.InstructionResult;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopForInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopIfInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.LoopInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.OutputInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.WaitForInstruction;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Vector;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SequencedPulseGeneratorBlockEntity
extends SmartBlockEntity {
    public static final int INSTRUCTION_CAPACITY = 7;
    private static final int MAX_RECURSION_DEPTH = 10;
    private static final float PARTICLE_DENSITY = 0.2f;
    Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentSignal = 0;
    boolean poweredPreviously = false;
    boolean isPowered;
    int infiniteLoopCounter = 0;

    public SequencedPulseGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        AdvancementBehaviour.registerAwardables(this, behaviours, CCAdvancements.PULSE_GEN_INFINITE_LOOP);
    }

    public boolean isIdle() {
        return this.currentInstruction < 0;
    }

    public int getCurrentSignal() {
        return this.currentSignal;
    }

    public boolean isPoweredPreviously() {
        return this.poweredPreviously;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public Instruction getCurrentInstruction() {
        return this.currentInstruction >= 0 && this.currentInstruction < this.instructions.size() ? this.instructions.get(this.currentInstruction) : null;
    }

    private void executeInstruction(Function<Instruction, Function<SequencedPulseGeneratorBlockEntity, InstructionResult>> instructionEvent, boolean allowImmediate) {
        this.executeInstruction(instructionEvent, allowImmediate, 0);
    }

    private void applySignal() {
        if ((Boolean)this.m_58900_().m_61143_((Property)SequencedPulseGeneratorBlock.POWERING) != this.currentSignal > 0) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SequencedPulseGeneratorBlock.POWERING, (Comparable)Boolean.valueOf(this.currentSignal > 0)), 2);
        }
        ((SequencedPulseGeneratorBlock)this.m_58900_().m_60734_()).m_52580_(this.f_58857_, this.m_58899_(), this.m_58900_());
    }

    private void executeInstruction(Function<Instruction, Function<SequencedPulseGeneratorBlockEntity, InstructionResult>> instructionEvent, boolean allowImmediate, int recursionDepth) {
        Instruction instruction = this.getCurrentInstruction();
        if (instruction == null) {
            this.currentInstruction = -1;
            if (this.currentSignal != 0) {
                this.currentSignal = 0;
                this.applySignal();
            }
            return;
        }
        InstructionResult result = instructionEvent.apply(instruction).apply(this);
        int prevSignal = this.currentSignal;
        this.currentSignal = instruction.getSignal();
        if (prevSignal != this.currentSignal) {
            this.applySignal();
        }
        this.currentInstruction = result.getNextInstruction(this.currentInstruction);
        if (result.isImmediate() && allowImmediate) {
            if (recursionDepth < 10) {
                this.executeInstruction(instructionEvent, true, recursionDepth + 1);
            } else {
                ++this.infiniteLoopCounter;
                if (this.f_58857_.m_213780_().m_188501_() < 0.2f) {
                    Vec3 loc = Vec3.m_82539_((Vec3i)this.m_58899_());
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, loc.f_82479_, loc.f_82480_, loc.f_82481_, 2, 0.1, 0.0, 0.1, 0.01);
                }
                if (!this.f_58857_.m_5776_() && this.infiniteLoopCounter > 101) {
                    this.infiniteLoopCounter = 0;
                    AdvancementBehaviour.tryAward((BlockEntity)this, CCAdvancements.PULSE_GEN_INFINITE_LOOP);
                }
            }
        } else {
            this.infiniteLoopCounter = 0;
        }
        if (recursionDepth == 0) {
            this.notifyUpdate();
        }
    }

    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.isPowered = (Boolean)this.m_58900_().m_61143_((Property)DiodeBlock.f_52496_);
        this.executeInstruction(i -> i::tick, true);
    }

    private void resetAllInstructions() {
        Vector newInstructions = new Vector(this.instructions.capacity());
        this.instructions.forEach(i -> newInstructions.add(i.copy()));
        this.instructions = newInstructions;
    }

    public void onRedstoneUpdate(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered == this.poweredPreviously) {
            return;
        }
        if (!this.poweredPreviously && isPowered && !this.isIdle()) {
            this.executeInstruction(i -> i::onRisingEdge, false);
        }
        if (this.poweredPreviously && !isPowered && !this.isIdle()) {
            this.executeInstruction(i -> i::onFallingEdge, false);
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle() || !isPowered) {
            return;
        }
        if (!this.f_58857_.m_276867_(this.f_58858_)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DiodeBlock.f_52496_, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        this.currentInstruction = 0;
        this.resetAllInstructions();
        this.executeInstruction(i -> i::tick, true);
    }

    public void reset() {
        this.resetAllInstructions();
        this.currentInstruction = -1;
        this.infiniteLoopCounter = 0;
        this.currentSignal = 0;
        this.applySignal();
        this.notifyUpdate();
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128405_("InstructionIndex", this.currentInstruction);
        nbt.m_128379_("PrevPowered", this.poweredPreviously);
        nbt.m_128405_("CurrentSignal", this.currentSignal);
        nbt.m_128365_("Instructions", (Tag)Instruction.serializeAll(this.instructions));
        super.write(nbt, clientPacket);
    }

    protected void read(CompoundTag nbt, boolean clientPacket) {
        this.currentInstruction = nbt.m_128451_("InstructionIndex");
        this.poweredPreviously = nbt.m_128471_("PrevPowered");
        this.currentSignal = nbt.m_128451_("CurrentSignal");
        ListTag list = nbt.m_128437_("Instructions", 10);
        this.instructions = Instruction.deserializeAll(list);
        super.read(nbt, clientPacket);
    }

    static {
        Instruction.register(new OutputInstruction(10, 15));
        Instruction.register(new WaitForInstruction(1, 0));
        Instruction.register(new LoopForInstruction(3));
        Instruction.register(new LoopIfInstruction(1));
        Instruction.register(new LoopInstruction());
        Instruction.register(new EndInstruction());
    }
}

