/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator.instructions;

import com.hlysine.create_connected.CCGuiTextures;
import com.hlysine.create_connected.Lang;
import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlockEntity;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.EndInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.InstructionResult;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.OutputInstruction;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class Instruction {
    private static final Map<String, Instruction> INSTRUCTION_MAP = new LinkedHashMap<String, Instruction>();
    private final String instructionId;
    private final CCGuiTextures background;
    @Nullable
    public final ParameterConfig parameter;
    public final boolean hasSignal;
    public final boolean terminal;
    private int value = 0;
    private int signal = 0;

    public static void register(Instruction instruction) {
        INSTRUCTION_MAP.put(instruction.instructionId, instruction);
    }

    public Instruction(String instructionId, CCGuiTextures background, @Nullable ParameterConfig parameter, boolean hasSignal, boolean terminal) {
        this.instructionId = instructionId;
        this.background = background;
        this.parameter = parameter;
        this.hasSignal = hasSignal;
        this.terminal = terminal;
    }

    public String getId() {
        return this.instructionId;
    }

    public int getOrdinal() {
        return INSTRUCTION_MAP.keySet().stream().toList().indexOf(this.getId());
    }

    public static Instruction getByOrdinal(int ordinal) {
        return INSTRUCTION_MAP.values().stream().toList().get(ordinal).copy();
    }

    public CCGuiTextures getBackground() {
        return this.background;
    }

    public InstructionResult tick(SequencedPulseGeneratorBlockEntity be) {
        return InstructionResult.incomplete();
    }

    public InstructionResult onRisingEdge(SequencedPulseGeneratorBlockEntity be) {
        return InstructionResult.incomplete();
    }

    public InstructionResult onFallingEdge(SequencedPulseGeneratorBlockEntity be) {
        return InstructionResult.incomplete();
    }

    public int getValue() {
        return this.value;
    }

    public int getSignal() {
        return this.signal;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setSignal(int signal) {
        this.signal = signal;
    }

    public abstract void writeState(CompoundTag var1);

    public abstract void readState(CompoundTag var1);

    public abstract Instruction copy();

    public static Vector<Instruction> createDefault() {
        Vector<Instruction> instructions = new Vector<Instruction>(7);
        instructions.add(new OutputInstruction(10, 15));
        instructions.add(new EndInstruction());
        return instructions;
    }

    public static Instruction create(String instructionId) {
        Instruction template = INSTRUCTION_MAP.get(instructionId);
        if (template == null) {
            return null;
        }
        return template.copy();
    }

    public CompoundTag serializeParams() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("ID", this.instructionId);
        if (this.hasSignal) {
            nbt.m_128405_("Signal", this.signal);
        }
        if (this.parameter != null) {
            nbt.m_128405_("Value", this.value);
        }
        return nbt;
    }

    public static Instruction deserializeParams(CompoundTag nbt) {
        String id = nbt.m_128461_("ID");
        Instruction instance = Instruction.create(id);
        if (instance == null) {
            return null;
        }
        if (instance.hasSignal) {
            instance.signal = nbt.m_128451_("Signal");
        }
        if (instance.parameter != null) {
            instance.value = nbt.m_128451_("Value");
        }
        return instance;
    }

    public static ListTag serializeAll(Vector<Instruction> instructions) {
        ListTag list = new ListTag();
        instructions.forEach(i -> {
            CompoundTag tag = i.serializeParams();
            i.writeState(tag);
            list.add((Object)tag);
        });
        return list;
    }

    public static Vector<Instruction> deserializeAll(ListTag list) {
        if (list.isEmpty()) {
            return Instruction.createDefault();
        }
        Vector<Instruction> instructions = new Vector<Instruction>(7);
        list.forEach(tag -> {
            Instruction instruction = Instruction.deserializeParams((CompoundTag)tag);
            if (instruction == null) {
                return;
            }
            instruction.readState((CompoundTag)tag);
            instructions.add(instruction);
        });
        return instructions;
    }

    public String getLangKey() {
        return "gui.sequenced_pulse_generator.instruction." + Lang.asId(this.instructionId);
    }

    public String getDescriptiveLangKey() {
        return this.getLangKey() + ".descriptive";
    }

    public String getParameterLangKey() {
        if (this.parameter != null) {
            return this.getLangKey() + "." + Lang.asId(this.parameter.parameterId);
        }
        return this.getLangKey() + ".missing";
    }

    public static List<Component> getOptions() {
        ArrayList<Component> options = new ArrayList<Component>();
        for (Instruction value : INSTRUCTION_MAP.values()) {
            options.add((Component)Lang.translateDirect(value.getDescriptiveLangKey(), new Object[0]));
        }
        return options;
    }

    public record ParameterConfig(String parameterId, int minValue, int maxValue, @Nullable Function<ScrollValueBehaviour.StepContext, Integer> stepFunction, int shiftStepValue, int defaultValue, @Nullable Function<Integer, String> formatter) {
        public static final Function<ScrollValueBehaviour.StepContext, Integer> timeStep = context -> {
            int v = context.currentValue;
            if (!context.forward) {
                --v;
            }
            if (v < 20) {
                return context.shift ? 20 : 1;
            }
            return context.shift ? 100 : 20;
        };
        public static final Function<Integer, String> timeFormat = value -> {
            if (value >= 20) {
                return value / 20 + "s";
            }
            return value + "t";
        };
        public static final Function<Integer, String> booleanFormat = value -> value == 1 ? "On" : "Off";
    }
}

