/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.botanypots.data.displaystate.AgingDisplayState;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.displaystate.SimpleDisplayState;
import net.darkhax.botanypots.data.displaystate.TransitionalDisplayState;
import net.darkhax.botanypots.data.displaystate.render.AgingDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.render.SimpleDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.render.TransitionalDisplayStateRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class DisplayStateRenderer<T extends DisplayState> {
    private static final Map<ResourceLocation, DisplayStateRenderer<DisplayState>> RENDERERS = new HashMap<ResourceLocation, DisplayStateRenderer<DisplayState>>();

    public static DisplayStateRenderer<DisplayState> getRenderer(DisplayState state) {
        DisplayStateRenderer<DisplayState> renderer = DisplayStateRenderer.getRenderer(state.getSerializer().getId());
        if (renderer != null) {
            return renderer;
        }
        throw new IllegalStateException("Display state " + state.getSerializer().getId() + " is not bound to a renderer.");
    }

    public static void renderState(DisplayState displayState, PoseStack stack, Level level, BlockPos pos, MultiBufferSource bufferSource, int light, int overlay, float progress) {
        DisplayStateRenderer.getRenderer(displayState).render(displayState, stack, level, pos, bufferSource, light, overlay, progress);
    }

    @Nullable
    public static DisplayStateRenderer<DisplayState> getRenderer(ResourceLocation id) {
        return RENDERERS.get(id);
    }

    public abstract void render(T var1, PoseStack var2, Level var3, BlockPos var4, MultiBufferSource var5, int var6, int var7, float var8);

    public static void init() {
        RENDERERS.put(SimpleDisplayState.ID, SimpleDisplayStateRenderer.RENDERER);
        RENDERERS.put(TransitionalDisplayState.ID, TransitionalDisplayStateRenderer.RENDERER);
        RENDERERS.put(AgingDisplayState.ID, AgingDisplayStateRenderer.RENDERER);
    }
}

