/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder.ui_list;

import com.gmail.rawlxxxviii.visual_keybinder.KeybindingPreset;
import com.gmail.rawlxxxviii.visual_keybinder.screen.AlternativeKeybindScreen;
import com.gmail.rawlxxxviii.visual_keybinder.screen.PresetsScreen;
import com.gmail.rawlxxxviii.visual_keybinder.util.FileUtil;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class KeyPresetOptionsList
extends ContainerObjectSelectionList<Entry> {
    private final PresetsScreen parentScreen;
    protected final Options options;

    public KeyPresetOptionsList(PresetsScreen parentScreen, Minecraft minecraft, Options options, int left, int top, int width, int height) {
        super(minecraft, width, height, top, height + top, 26);
        this.options = options;
        this.m_93496_(false);
        this.f_93389_ = height;
        this.f_93393_ = left;
        this.f_93392_ = width + this.f_93393_;
        this.parentScreen = parentScreen;
        this.buildEntries();
    }

    private void buildEntries() {
        this.m_93516_();
        List<KeybindingPreset> presets = FileUtil.getPresets();
        if (presets == null) {
            return;
        }
        for (KeybindingPreset a : presets) {
            this.m_7085_((AbstractSelectionList.Entry)new PresetEntry(a, this.parentScreen.isPresetActive(a)));
        }
        this.m_7085_((AbstractSelectionList.Entry)new EmptyEntry());
        this.m_7085_((AbstractSelectionList.Entry)new ResetAllEntry());
        this.m_7085_((AbstractSelectionList.Entry)new UnbindAllEntry());
    }

    public void onBindingsUpdated() {
        this.buildEntries();
        this.m_93410_(this.m_93517_());
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93388_ + this.f_93393_ - 6;
    }

    public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
        return super.m_94729_(p_94730_, p_94731_);
    }

    public void m_94757_(double p_94758_, double p_94759_) {
        super.m_94757_(p_94758_, p_94759_);
    }

    public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
        return super.m_6375_(p_94695_, p_94696_, p_94697_);
    }

    public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
        return super.m_6348_(p_94722_, p_94723_, p_94724_);
    }

    public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
        return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
        return super.m_7933_(p_94710_, p_94711_, p_94712_);
    }

    public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
        return super.m_7920_(p_94715_, p_94716_, p_94717_);
    }

    public boolean m_5534_(char p_94683_, int p_94684_) {
        return super.m_5534_(p_94683_, p_94684_);
    }

    public void m_94725_(@Nullable GuiEventListener p_94726_) {
        super.m_94725_(p_94726_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class PresetEntry
    extends Entry {
        private final KeybindingPreset keybindingPreset;
        private final Button saveButton;
        private final Button loadButton;
        private final Button deleteButton;
        private final boolean isPresetActive;

        PresetEntry(KeybindingPreset keybindingPreset, boolean isPresetActive) {
            this.keybindingPreset = keybindingPreset;
            this.isPresetActive = isPresetActive;
            int buttonWidth = 50;
            this.saveButton = new Button.Builder((Component)Component.m_237113_((String)"Save"), p_193939_ -> KeyPresetOptionsList.this.parentScreen.savePreset(keybindingPreset.getName())).m_252794_(KeyPresetOptionsList.this.getRight() - (buttonWidth + 5) * 3, 0).m_253046_(buttonWidth, 20).m_253136_();
            this.saveButton.f_93623_ = !keybindingPreset.isReadOnly();
            this.loadButton = new Button.Builder((Component)Component.m_237113_((String)"Load"), p_193939_ -> KeyPresetOptionsList.this.parentScreen.loadPreset(keybindingPreset.getName())).m_252794_(KeyPresetOptionsList.this.getRight() - (buttonWidth + 5) * 2, 0).m_253046_(buttonWidth, 20).m_253136_();
            this.loadButton.f_93623_ = !isPresetActive;
            this.deleteButton = new Button.Builder((Component)Component.m_237113_((String)"Delete"), p_193935_ -> KeyPresetOptionsList.this.parentScreen.deletePreset(keybindingPreset.getName())).m_252794_(KeyPresetOptionsList.this.getRight() - buttonWidth - 5, 0).m_253046_(buttonWidth, 20).m_253136_();
            this.deleteButton.f_93623_ = !keybindingPreset.isReadOnly();
        }

        public Button getLoadButton() {
            return this.loadButton;
        }

        public Button getSaveButton() {
            return this.saveButton;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.saveButton, (Object)this.loadButton, (Object)this.deleteButton);
        }

        public void m_6311_(GuiGraphics guiGraphics, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
            guiGraphics.m_280588_(KeyPresetOptionsList.this.getLeft(), KeyPresetOptionsList.this.getTop(), KeyPresetOptionsList.this.getRight(), KeyPresetOptionsList.this.getBottom());
            guiGraphics.m_280430_(KeyPresetOptionsList.this.parentScreen.getMinecraft().f_91062_, (Component)Component.m_237113_((String)this.keybindingPreset.getName()), KeyPresetOptionsList.this.m_5747_() + 5, KeyPresetOptionsList.this.m_7610_(p_193924_) + 6, this.isPresetActive ? AlternativeKeybindScreen.ACTIVE_COLOR : Color.white.getRGB());
            this.saveButton.m_253211_(p_193925_);
            this.saveButton.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            this.loadButton.m_253211_(p_193925_);
            this.loadButton.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            this.deleteButton.m_253211_(p_193925_);
            this.deleteButton.setFGColor(this.deleteButton.f_93623_ ? AlternativeKeybindScreen.DANGER_COLOR : Color.GRAY.getRGB());
            this.deleteButton.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            guiGraphics.m_280618_();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EmptyEntry
    extends Entry {
        EmptyEntry() {
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public void m_6311_(GuiGraphics poseStack, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ResetAllEntry
    extends Entry {
        private final Button button;

        ResetAllEntry() {
            int buttonWidth = 50;
            this.button = new Button.Builder((Component)Component.m_237113_((String)"Reset"), p_193939_ -> KeyPresetOptionsList.this.parentScreen.resetAll()).m_252794_(KeyPresetOptionsList.this.getRight() - (buttonWidth + 5) * 3, 0).m_253046_(100, 20).m_253136_();
            this.button.f_93623_ = KeyPresetOptionsList.this.parentScreen.hasNonDefaultBindings();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(GuiGraphics guiGraphics, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
            guiGraphics.m_280588_(KeyPresetOptionsList.this.getLeft(), KeyPresetOptionsList.this.getTop(), KeyPresetOptionsList.this.getRight(), KeyPresetOptionsList.this.getBottom());
            guiGraphics.m_280430_(KeyPresetOptionsList.this.parentScreen.getMinecraft().f_91062_, (Component)Component.m_237113_((String)"Reset to defaults"), KeyPresetOptionsList.this.m_5747_() + 5, KeyPresetOptionsList.this.m_7610_(p_193924_) + 6, KeyPresetOptionsList.this.parentScreen.hasNonDefaultBindings() ? Color.LIGHT_GRAY.getRGB() : AlternativeKeybindScreen.ACTIVE_COLOR);
            this.button.m_253211_(p_193925_);
            this.button.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            guiGraphics.m_280618_();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class UnbindAllEntry
    extends Entry {
        private final Button button;

        UnbindAllEntry() {
            int buttonWidth = 50;
            this.button = new Button.Builder((Component)Component.m_237113_((String)"Unbind"), p_193939_ -> KeyPresetOptionsList.this.parentScreen.unbindAll()).m_252794_(KeyPresetOptionsList.this.getRight() - (buttonWidth + 5) * 3, 0).m_253046_(100, 20).m_253136_();
            this.button.f_93623_ = KeyPresetOptionsList.this.parentScreen.hasBoundBindings();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(GuiGraphics guiGraphics, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
            guiGraphics.m_280588_(KeyPresetOptionsList.this.getLeft(), KeyPresetOptionsList.this.getTop(), KeyPresetOptionsList.this.getRight(), KeyPresetOptionsList.this.getBottom());
            guiGraphics.m_280430_(KeyPresetOptionsList.this.parentScreen.getMinecraft().f_91062_, (Component)Component.m_237113_((String)"Unbind all keybindings"), KeyPresetOptionsList.this.m_5747_() + 5, KeyPresetOptionsList.this.m_7610_(p_193924_) + 6, KeyPresetOptionsList.this.parentScreen.hasBoundBindings() ? Color.LIGHT_GRAY.getRGB() : AlternativeKeybindScreen.ACTIVE_COLOR);
            this.button.m_253211_(p_193925_);
            this.button.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            guiGraphics.m_280618_();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

