/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters;

import dev.latvian.mods.itemfilters.ItemFilters;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<CacheKey, List<ItemStack>> cache = new Object2ObjectLinkedOpenHashMap(1024);

    @NotNull
    public static List<ItemStack> getCachedDisplayStacks(ItemStack filterStack) {
        CacheKey key = new CacheKey(filterStack);
        List<ItemStack> result = (List<ItemStack>)cache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(filterStack);
            cache.put((Object)key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<ItemStack> computeMatchingStacks(ItemStack filterStack) {
        IItemFilter f = (IItemFilter)filterStack.m_41720_();
        ItemFilters.proxy.registryAccess().ifPresent(ra -> CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)true, (HolderLookup.Provider)ra));
        return CreativeModeTabs.m_258007_().m_261235_().stream().filter(candidate -> f.filter(filterStack, (ItemStack)candidate)).toList();
    }

    public static void clear() {
        cache.clear();
    }

    private static class CacheKey {
        private final int key;

        private CacheKey(ItemStack filterStack) {
            this.key = Objects.hash(BuiltInRegistries.f_257033_.m_7447_((Object)filterStack.m_41720_()), filterStack.m_41782_() ? filterStack.m_41783_().hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.key == cacheKey.key;
        }

        public int hashCode() {
            return Integer.hashCode(this.key);
        }
    }
}

