/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;

public interface ResourceSelector<S extends ResourceSelector<S>> {
    public static final Codec<ResourceSelector<?>> CODEC = ExtraCodecs.f_252400_.flatXmap(element -> {
        JsonPrimitive primitive;
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
            return DataResult.success((Object)new NamesResourceSelector(new ResourceLocation(primitive.getAsString())));
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            String type = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
            Serializer<?> serializer = ResourceSelectorSerializers.INSTANCE.getSerializer(type);
            if (serializer == null) {
                return DataResult.error(() -> "Unknown selector type: " + type);
            }
            try {
                return DataResult.success(serializer.deserialize(jsonObject.get("config")));
            }
            catch (JsonParseException exception) {
                return DataResult.error(exception::getMessage);
            }
        }
        if (element == null) {
            return DataResult.error(() -> "Missing 'selector' member!");
        }
        return DataResult.error(() -> "'selector' must be a string or object!");
    }, selector -> {
        NamesResourceSelector namesResourceSelector;
        Set<ResourceLocation> names;
        if (selector instanceof NamesResourceSelector && (names = (namesResourceSelector = (NamesResourceSelector)selector).names()).size() == 1) {
            return DataResult.success((Object)new JsonPrimitive(names.iterator().next().toString()));
        }
        Serializer serializer = selector.getSerializer();
        String type = ResourceSelectorSerializers.INSTANCE.getSerializerID(serializer);
        if (type == null) {
            return DataResult.error(() -> "Could not find name for selector serializer: " + serializer);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(type));
        jsonObject.add("config", selector.serialize());
        return DataResult.success((Object)jsonObject);
    });

    public static Predicate<ResourceLocation> predicate(@Nullable ResourceSelector<?> selector) {
        return selector == null ? location -> true : (Predicate)selector.select().map(set -> set::contains, predicate -> predicate);
    }

    default public JsonElement serialize() {
        return this.getSerializer().serialize(this);
    }

    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select();

    public Serializer<S> getSerializer();

    public static interface Serializer<S extends ResourceSelector<?>> {
        public JsonElement serialize(S var1);

        public S deserialize(JsonElement var1);
    }
}

