/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.ChoiceResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.EmptyResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.MultiResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.RegexResourceSelector;
import javax.annotation.Nullable;

public enum ResourceSelectorSerializers {
    INSTANCE;

    public static final ChoiceResourceSelector.Serializer CHOICE;
    public static final EmptyResourceSelector.Serializer EMPTY;
    public static final MultiResourceSelector.Serializer MULTI;
    public static final NamesResourceSelector.Serializer NAMES;
    public static final RegexResourceSelector.Serializer REGEX;
    private final BiMap<String, ResourceSelector.Serializer<?>> serializers = HashBiMap.create();

    public synchronized <S extends ResourceSelector.Serializer<?>> S register(String id, S type) {
        if (this.serializers.containsKey((Object)id)) {
            throw new IllegalArgumentException("A selector with the ID '" + id + "' is already registered!");
        }
        this.serializers.put((Object)id, type);
        return type;
    }

    @Nullable
    public ResourceSelector.Serializer<?> getSerializer(String id) {
        return (ResourceSelector.Serializer)this.serializers.get((Object)id);
    }

    @Nullable
    public String getSerializerID(ResourceSelector.Serializer<?> type) {
        return (String)this.serializers.inverse().get(type);
    }

    static {
        CHOICE = INSTANCE.register("choice", new ChoiceResourceSelector.Serializer());
        EMPTY = INSTANCE.register("empty", new EmptyResourceSelector.Serializer());
        MULTI = INSTANCE.register("multi", new MultiResourceSelector.Serializer());
        NAMES = INSTANCE.register("names", new NamesResourceSelector.Serializer());
        REGEX = INSTANCE.register("regex", new RegexResourceSelector.Serializer());
    }
}

