/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.block.sign.BlueprintCeilingHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.common.item.BEWLRFuelBlockItem;
import com.teamabnormals.blueprint.common.item.FuelBlockItem;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockSubRegistryHelper
extends AbstractSubRegistryHelper<Block> {
    protected final DeferredRegister<Item> itemRegister;

    public BlockSubRegistryHelper(RegistryHelper parent) {
        this(parent, parent.getSubHelper(ForgeRegistries.ITEMS).getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, ISubRegistryHelper<Item> itemHelper) {
        this(parent, itemHelper.getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> itemRegister, DeferredRegister<Block> deferredRegister) {
        super(parent, deferredRegister);
        this.itemRegister = itemRegister;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<BlueprintTrappedChestBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<BlueprintChestBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, Item.Properties properties) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithItem(String name, Supplier<? extends B> supplier, Supplier<BlockItem> item) {
        this.itemRegister.register(name, item);
        return this.deferredRegister.register(name, supplier);
    }

    public <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        return this.deferredRegister.register(name, supplier);
    }

    public <B extends Block> RegistryObject<B> createFuelBlock(String name, Supplier<? extends B> supplier, int burnTime) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties()));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithBEWLR(String name, Supplier<? extends B> supplier, Supplier<Callable<BEWLRBlockItem.LazyBEWLR>> belwr) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BEWLRBlockItem((Block)block.get(), new Item.Properties(), belwr));
        return block;
    }

    public <B extends Block> RegistryObject<B> createDoubleHighBlock(String name, Supplier<? extends B> supplier) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public <B extends Block> RegistryObject<B> createStandingAndWallBlock(String name, Supplier<? extends B> supplier, Supplier<? extends B> wallSupplier, Direction direction) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new StandingAndWallBlockItem((Block)block.get(), (Block)wallSupplier.get(), new Item.Properties(), direction));
        return block;
    }

    public <B extends Block> RegistryObject<B> createRareBlock(String name, Supplier<? extends B> supplier, Rarity rarity) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity)));
        return block;
    }

    public RegistryObject<BlueprintChestBlock> createChestBlock(String name, String materialName, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials(modId, materialName, false);
        RegistryObject block = this.deferredRegister.register(name, () -> new BlueprintChestBlock(chestMaterialsName, properties));
        this.itemRegister.register(name, () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> BlockSubRegistryHelper.chestBEWLR(false), 300));
        return block;
    }

    public RegistryObject<BlueprintChestBlock> createChestBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createChestBlock(materialName + "_chest", materialName, properties);
    }

    public RegistryObject<BlueprintTrappedChestBlock> createTrappedChestBlock(String name, String materialName, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name, () -> new BlueprintTrappedChestBlock(modId + ":" + materialName + "_trapped", properties));
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials(modId, materialName, true);
        this.itemRegister.register(name, () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> BlockSubRegistryHelper.chestBEWLR(true), 300));
        return block;
    }

    @Deprecated
    public RegistryObject<BlueprintTrappedChestBlock> createTrappedChestBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createTrappedChestBlock(materialName + "_trapped_chest", materialName, properties);
    }

    public RegistryObject<BlueprintTrappedChestBlock> createTrappedChestBlockNamed(String materialName, BlockBehaviour.Properties properties) {
        return this.createTrappedChestBlock("trapped_" + materialName + "_chest", materialName, properties);
    }

    public Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> createSignBlock(String name, WoodType woodType, BlockBehaviour.Properties properties) {
        RegistryObject standing = this.deferredRegister.register(name + "_sign", () -> new BlueprintStandingSignBlock(properties, woodType));
        RegistryObject wall = this.deferredRegister.register(name + "_wall_sign", () -> new BlueprintWallSignBlock(properties.lootFrom((Supplier)standing), woodType));
        this.itemRegister.register(name + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)standing.get(), (Block)wall.get()));
        return Pair.of((Object)standing, (Object)wall);
    }

    public Pair<RegistryObject<BlueprintCeilingHangingSignBlock>, RegistryObject<BlueprintWallHangingSignBlock>> createHangingSignBlock(String name, WoodType woodType, BlockBehaviour.Properties properties) {
        RegistryObject ceiling = this.deferredRegister.register(name + "_hanging_sign", () -> new BlueprintCeilingHangingSignBlock(properties, woodType));
        RegistryObject wall = this.deferredRegister.register(name + "_wall_hanging_sign", () -> new BlueprintWallHangingSignBlock(properties.lootFrom((Supplier)ceiling), woodType));
        this.itemRegister.register(name + "_hanging_sign", () -> new HangingSignItem((Block)ceiling.get(), (Block)wall.get(), new Item.Properties().m_41487_(16)));
        return Pair.of((Object)ceiling, (Object)wall);
    }
}

