/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.minimap.TranslatedOption;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.gui.ToggleVisibilityButton;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientTextComponentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class MinimapInfoSortScreen
extends AbstractThreePanelScreen<MinimapInfoSortEntry> {
    private List<ResourceLocation> infoSortList = new LinkedList<ResourceLocation>();

    public MinimapInfoSortScreen() {
        this.setHeight(200);
        this.setWidth(200);
        ((List)FTBChunksClientConfig.MINIMAP_INFO_ORDER.get()).forEach(s -> this.infoSortList.add(new ResourceLocation(s)));
        this.showBottomPanel(false);
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }

    protected int getTopPanelHeight() {
        return 22;
    }

    protected MinimapInfoSortEntry createMainPanel() {
        return new MinimapInfoSortEntry((Panel)this);
    }

    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    private void saveConfig() {
        LinkedList list = new LinkedList();
        this.infoSortList.forEach(resourceLocation -> list.add(resourceLocation.toString()));
        FTBChunksClientConfig.MINIMAP_INFO_ORDER.set(list);
        FTBChunksClientConfig.saveConfig();
        FTBChunksClient.INSTANCE.setupComponents();
    }

    private boolean isComponentDisabled(MinimapInfoComponent component) {
        return !FTBChunksAPI.clientApi().isMinimapComponentEnabled(component);
    }

    private void setComponentEnabled(MinimapInfoComponent component, boolean enabled) {
        FTBChunksAPI.clientApi().setMinimapComponentEnabled(component, enabled);
    }

    private boolean isTranslatedOptionEnabled(MinimapInfoComponent component, TranslatedOption option) {
        Map stringStringMap = (Map)FTBChunksClientConfig.MINIMAP_SETTINGS.get();
        if (!stringStringMap.containsKey(component.id().toString())) {
            stringStringMap.put(component.id().toString(), option.optionName());
        }
        return ((String)stringStringMap.get(component.id().toString())).equals(option.optionName());
    }

    private void setTranslatedOptionEnabled(MinimapInfoComponent component, TranslatedOption option) {
        Map stringStringMap = (Map)FTBChunksClientConfig.MINIMAP_SETTINGS.get();
        stringStringMap.put(component.id().toString(), option.optionName());
        FTBChunksClientConfig.MINIMAP_SETTINGS.set((Object)stringStringMap);
        FTBChunksClientConfig.saveConfig();
    }

    public class MinimapInfoSortEntry
    extends Panel {
        private final Map<ResourceLocation, InfoEntry> entryMap;

        public MinimapInfoSortEntry(Panel panel) {
            super(panel);
            this.entryMap = new HashMap<ResourceLocation, InfoEntry>();
            for (MinimapInfoComponent minimapComponent : FTBChunksAPI.clientApi().getMinimapComponents()) {
                this.entryMap.put(minimapComponent.id(), new InfoEntry(minimapComponent, this));
            }
        }

        public void addWidgets() {
            this.addAll(this.entryMap.values());
        }

        public void alignWidgets() {
            int height = 0;
            for (ResourceLocation id : MinimapInfoSortScreen.this.infoSortList) {
                InfoEntry infoEntry = this.entryMap.get(id);
                if (infoEntry == null) continue;
                infoEntry.setPosAndSize(0, height, this.width, 24);
                infoEntry.alignWidgets();
                height += 24;
            }
        }
    }

    protected class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private final TextField titleLabel;

        protected CustomTopPanel() {
            super((AbstractThreePanelScreen)MinimapInfoSortScreen.this);
            this.titleLabel = new TextField((Panel)this);
        }

        public void addWidgets() {
            this.titleLabel.setText((Component)Component.m_237115_((String)"ftbchunks.gui.sort_minimap_info"));
            this.titleLabel.addFlags(32);
            this.add((Widget)this.titleLabel);
        }

        public void alignWidgets() {
            this.titleLabel.setPosAndSize(4, 0, this.titleLabel.width, this.height);
        }
    }

    public static class SortScreenButton
    extends SimpleButton {
        public SortScreenButton(Panel panel, Component text, Icon icon, SimpleButton.Callback c) {
            super(panel, text, icon, c);
        }

        public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.drawIcon(graphics, theme, x - 1, y - 2, 6, 8);
        }
    }

    public class InfoEntry
    extends Panel {
        private final Button down;
        private final Button up;
        private final SimpleButton hideButton;
        private final TextField field;
        private final MinimapInfoComponent infoComponent;
        private final SimpleButton configButton;

        public InfoEntry(final MinimapInfoComponent infoComponent, Panel panel) {
            super(panel);
            this.hideButton = ToggleVisibilityButton.create(this, !MinimapInfoSortScreen.this.isComponentDisabled(infoComponent), enabled -> MinimapInfoSortScreen.this.setComponentEnabled(infoComponent, (boolean)enabled));
            this.down = new SortScreenButton(this, (Component)Component.m_237115_((String)"ftbchunks.gui.move_up"), Icons.UP, (widget, button) -> this.move(false, InfoEntry.isShiftKeyDown()));
            this.up = new SortScreenButton(this, (Component)Component.m_237115_((String)"ftbchunks.gui.move_down"), Icons.DOWN, (widget, button) -> this.move(true, InfoEntry.isShiftKeyDown()));
            this.configButton = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.settings"), Icons.SETTINGS, (widget, button) -> {
                ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
                for (TranslatedOption translatedOption : infoComponent.getConfigComponents()) {
                    ContextMenuItem item = new ContextMenuItem((Component)Component.m_237115_((String)translatedOption.translationKey()), MinimapInfoSortScreen.this.isTranslatedOptionEnabled(infoComponent, translatedOption) ? Icons.ACCEPT : Icons.REMOVE_GRAY, button1 -> MinimapInfoSortScreen.this.setTranslatedOptionEnabled(infoComponent, translatedOption));
                    items.add(item);
                }
                MinimapInfoSortScreen.this.openContextMenu(items);
                this.playClickSound();
            }){

                public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                    super.drawIcon(graphics, theme, x, y, 12, 12);
                }
            };
            this.field = new TextField(this){

                public void addMouseOverText(TooltipList list) {
                    list.add(infoComponent.description());
                }
            };
            this.infoComponent = infoComponent;
        }

        public void addWidgets() {
            int listIndex = MinimapInfoSortScreen.this.infoSortList.indexOf(this.infoComponent.id());
            if (listIndex != 0) {
                this.add((Widget)this.down);
            }
            if (listIndex != MinimapInfoSortScreen.this.infoSortList.size() - 1) {
                this.add((Widget)this.up);
            }
            this.add((Widget)this.hideButton);
            this.add((Widget)this.field);
            if (!this.infoComponent.getConfigComponents().isEmpty()) {
                this.add((Widget)this.configButton);
            }
        }

        public void alignWidgets() {
            this.down.setPosAndSize(6, this.height / 6 + 1, 6, 8);
            this.up.setPosAndSize(6, this.height / 6 + 11, 6, 8);
            this.hideButton.setPosAndSize(this.width - 18, this.height / 6, 12, 12);
            this.field.setPosAndSize(16, 8, this.width - 37, this.height);
            if (!this.infoComponent.getConfigComponents().isEmpty()) {
                this.configButton.setPos(this.width - 18 - 14, this.height / 6 + 2);
            }
            this.field.setText(ClientTextComponentUtils.ellipsize((Font)MinimapInfoSortScreen.this.getTheme().getFont(), (FormattedText)this.infoComponent.displayName(), (int)(this.hideButton.getPosX() - 14 - 5)).getString());
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawWidget(graphics, x, y, w, h, this.getWidgetType());
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
            super.draw(graphics, theme, x, y, w, h);
        }

        private void move(boolean forward, boolean end) {
            LinkedList<ResourceLocation> list = new LinkedList<ResourceLocation>(MinimapInfoSortScreen.this.infoSortList);
            if (end) {
                if (forward) {
                    list.remove(this.infoComponent.id());
                    list.add(this.infoComponent.id());
                } else {
                    list.remove(this.infoComponent.id());
                    list.add(0, this.infoComponent.id());
                }
            } else {
                int index = list.indexOf(this.infoComponent.id());
                if (index == -1) {
                    return;
                }
                if (forward) {
                    if (index == list.size() - 1) {
                        return;
                    }
                    list.remove(index);
                    list.add(index + 1, this.infoComponent.id());
                } else {
                    if (index == 0) {
                        return;
                    }
                    list.remove(index);
                    list.add(index - 1, this.infoComponent.id());
                }
            }
            MinimapInfoSortScreen.this.infoSortList = list;
            MinimapInfoSortScreen.this.saveConfig();
            this.parent.refreshWidgets();
        }
    }
}

