/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.Date;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class UpdateForceLoadExpiryPacket
extends BaseC2SMessage {
    private final ChunkDimPos pos;
    private final long relativeExpiryTime;

    public UpdateForceLoadExpiryPacket(ChunkDimPos pos, Date expiryDate) {
        this.pos = pos;
        this.relativeExpiryTime = expiryDate == null ? 0L : Math.max(0L, expiryDate.getTime() - System.currentTimeMillis());
    }

    public UpdateForceLoadExpiryPacket(FriendlyByteBuf buf) {
        this.pos = new ChunkDimPos(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_()), buf.readInt(), buf.readInt());
        this.relativeExpiryTime = buf.readLong();
    }

    public MessageType getType() {
        return FTBChunksNet.UPDATE_FORCE_LOAD_EXPIRY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.pos.dimension().m_135782_());
        buf.writeInt(this.pos.x());
        buf.writeInt(this.pos.z());
        buf.writeLong(this.relativeExpiryTime);
    }

    public void handle(NetworkManager.PacketContext context) {
        ClaimedChunkImpl chunk;
        ServerPlayer sp;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_9236_().m_46472_().equals(this.pos.dimension()) && (chunk = ClaimedChunkManagerImpl.getInstance().getChunk(this.pos)) != null && chunk.getTeamData().getTeam().getRankForPlayer(sp.m_20148_()).isMemberOrBetter() && chunk.isForceLoaded()) {
            chunk.setForceLoadExpiryTime(this.relativeExpiryTime == 0L ? 0L : System.currentTimeMillis() + this.relativeExpiryTime);
            SendChunkPacket packet = new SendChunkPacket((ResourceKey<Level>)this.pos.dimension(), chunk.getTeamData().getTeam().getId(), new SendChunkPacket.SingleChunk(System.currentTimeMillis(), chunk.getPos().x(), chunk.getPos().z(), chunk));
            packet.sendTo(sp);
        }
    }
}

