/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.category;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.category.Entity;
import com.gitlab.cdagaming.craftpresence.core.config.category.Gui;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Advanced
extends Module
implements Serializable {
    private static final long serialVersionUID = 6035241954568785784L;
    private static final Advanced DEFAULT = new Advanced();
    public boolean enablePerGui = false;
    public boolean enablePerItem = false;
    public boolean enablePerEntity = false;
    public boolean formatWords = true;
    public boolean debugMode = false;
    public boolean verboseMode = false;
    public int refreshRate = 2;
    public boolean allowPlaceholderPreviews = false;
    public Gui guiSettings = new Gui();
    public Map<String, String> itemMessages = new HashMapBuilder().put((Object)"default", (Object)Constants.TRANSLATOR.translate("craftpresence.defaults.advanced.item_messages", new Object[0])).build();
    public Entity entitySettings = new Entity();
    public boolean allowEndpointIcons = true;
    public String serverIconEndpoint = "https://api.mcsrvstat.us/icon/{server.address.short}";
    public String playerSkinEndpoint = "https://mc-heads.net/avatar/{getOrDefault(player.uuid.short, player.name)}";
    public boolean allowDuplicatePackets = false;
    public int maxConnectionAttempts = 10;
    public boolean enableClassGraph = false;
    public boolean useClassLoader = Constants.USE_CLASS_LOADER;

    public Advanced(Advanced other) {
        this.transferFrom(other);
    }

    public Advanced() {
    }

    @Override
    public Advanced getDefaults() {
        return new Advanced(DEFAULT);
    }

    @Override
    public Advanced copy() {
        return new Advanced(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Advanced) {
            Advanced data = (Advanced)target;
            if (!this.equals(target)) {
                this.enablePerGui = data.enablePerGui;
                this.enablePerItem = data.enablePerItem;
                this.enablePerEntity = data.enablePerEntity;
                this.formatWords = data.formatWords;
                this.debugMode = data.debugMode;
                this.verboseMode = data.verboseMode;
                this.refreshRate = data.refreshRate;
                this.allowPlaceholderPreviews = data.allowPlaceholderPreviews;
                this.guiSettings = new Gui(data.guiSettings);
                this.itemMessages.clear();
                this.itemMessages.putAll(data.itemMessages);
                this.entitySettings = new Entity(data.entitySettings);
                this.allowEndpointIcons = data.allowEndpointIcons;
                this.serverIconEndpoint = data.serverIconEndpoint;
                this.playerSkinEndpoint = data.playerSkinEndpoint;
                this.allowDuplicatePackets = data.allowDuplicatePackets;
                this.maxConnectionAttempts = data.maxConnectionAttempts;
                this.enableClassGraph = data.enableClassGraph;
                this.useClassLoader = data.useClassLoader;
            }
        }
    }

    @Override
    public Object getProperty(String name) {
        return switch (name) {
            case "enablePerGui" -> this.enablePerGui;
            case "enablePerItem" -> this.enablePerItem;
            case "enablePerEntity" -> this.enablePerEntity;
            case "formatWords" -> this.formatWords;
            case "debugMode" -> this.debugMode;
            case "verboseMode" -> this.verboseMode;
            case "refreshRate" -> this.refreshRate;
            case "allowPlaceholderPreviews" -> this.allowPlaceholderPreviews;
            case "guiSettings" -> this.guiSettings;
            case "itemMessages" -> this.itemMessages;
            case "entitySettings" -> this.entitySettings;
            case "allowEndpointIcons" -> this.allowEndpointIcons;
            case "serverIconEndpoint" -> this.serverIconEndpoint;
            case "playerSkinEndpoint" -> this.playerSkinEndpoint;
            case "allowDuplicatePackets" -> this.allowDuplicatePackets;
            case "maxConnectionAttempts" -> this.maxConnectionAttempts;
            case "enableClassGraph" -> this.enableClassGraph;
            case "useClassLoader" -> this.useClassLoader;
            default -> null;
        };
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            switch (name) {
                case "enablePerGui": {
                    this.enablePerGui = (Boolean)value;
                    break;
                }
                case "enablePerItem": {
                    this.enablePerItem = (Boolean)value;
                    break;
                }
                case "enablePerEntity": {
                    this.enablePerEntity = (Boolean)value;
                    break;
                }
                case "formatWords": {
                    this.formatWords = (Boolean)value;
                    break;
                }
                case "debugMode": {
                    this.debugMode = (Boolean)value;
                    break;
                }
                case "verboseMode": {
                    this.verboseMode = (Boolean)value;
                    break;
                }
                case "refreshRate": {
                    this.refreshRate = (Integer)value;
                    break;
                }
                case "allowPlaceholderPreviews": {
                    this.allowPlaceholderPreviews = (Boolean)value;
                    break;
                }
                case "guiSettings": {
                    this.guiSettings = (Gui)value;
                    break;
                }
                case "itemMessages": {
                    this.itemMessages = (Map)value;
                    break;
                }
                case "entitySettings": {
                    this.entitySettings = (Entity)value;
                    break;
                }
                case "allowEndpointIcons": {
                    this.allowEndpointIcons = (Boolean)value;
                    break;
                }
                case "serverIconEndpoint": {
                    this.serverIconEndpoint = (String)value;
                    break;
                }
                case "playerSkinEndpoint": {
                    this.playerSkinEndpoint = (String)value;
                    break;
                }
                case "allowDuplicatePackets": {
                    this.allowDuplicatePackets = (Boolean)value;
                    break;
                }
                case "maxConnectionAttempts": {
                    this.maxConnectionAttempts = (Integer)value;
                    break;
                }
                case "enableClassGraph": {
                    this.enableClassGraph = (Boolean)value;
                    break;
                }
                case "useClassLoader": {
                    this.useClassLoader = (Boolean)value;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Advanced)) {
            return false;
        }
        Advanced other = (Advanced)obj;
        return Objects.equals(other.enablePerGui, this.enablePerGui) && Objects.equals(other.enablePerItem, this.enablePerItem) && Objects.equals(other.enablePerEntity, this.enablePerEntity) && Objects.equals(other.formatWords, this.formatWords) && Objects.equals(other.debugMode, this.debugMode) && Objects.equals(other.verboseMode, this.verboseMode) && Objects.equals(other.refreshRate, this.refreshRate) && Objects.equals(other.allowPlaceholderPreviews, this.allowPlaceholderPreviews) && Objects.equals(other.guiSettings, this.guiSettings) && Objects.equals(other.itemMessages, this.itemMessages) && Objects.equals(other.entitySettings, this.entitySettings) && Objects.equals(other.allowEndpointIcons, this.allowEndpointIcons) && Objects.equals(other.serverIconEndpoint, this.serverIconEndpoint) && Objects.equals(other.playerSkinEndpoint, this.playerSkinEndpoint) && Objects.equals(other.allowDuplicatePackets, this.allowDuplicatePackets) && Objects.equals(other.maxConnectionAttempts, this.maxConnectionAttempts) && Objects.equals(other.enableClassGraph, this.enableClassGraph) && Objects.equals(other.useClassLoader, this.useClassLoader);
    }

    public int hashCode() {
        return Objects.hash(this.enablePerGui, this.enablePerItem, this.enablePerEntity, this.formatWords, this.debugMode, this.verboseMode, this.refreshRate, this.allowPlaceholderPreviews, this.guiSettings, this.itemMessages, this.entitySettings, this.allowEndpointIcons, this.serverIconEndpoint, this.playerSkinEndpoint, this.allowDuplicatePackets, this.maxConnectionAttempts, this.enableClassGraph, this.useClassLoader);
    }
}

