/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.impl.discord;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAsset;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import craftpresence.external.com.jagrosh.discordipc.entities.PartyPrivacy;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.time.temporal.Temporal;
import java.util.Map;

public record CompiledPresence(ActivityType activityType, PartyPrivacy partyPrivacy, String details, String state, String rawLargeImage, String rawSmallImage, DiscordAsset largeAsset, DiscordAsset smallAsset, String largeImageKey, String smallImageKey, String largeImageText, String smallImageText, long startTimestamp, long endTimestamp, JsonArray buttons, boolean instance, boolean isMain) {
    public String getTimeString() {
        boolean isElapsed = this.endTimestamp <= 0L;
        long seconds = TimeUtils.getDuration((Temporal)TimeUtils.fromEpochMilli((long)this.startTimestamp), (Temporal)(isElapsed ? TimeUtils.getCurrentTime() : TimeUtils.fromEpochMilli((long)this.endTimestamp))).getSeconds();
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long remainingSeconds = seconds % 60L;
        StringBuilder timeStringBuilder = new StringBuilder();
        if (hours > 0L) {
            if (hours < 10L) {
                timeStringBuilder.append('0');
            }
            timeStringBuilder.append(hours).append(':');
        }
        if (minutes < 10L) {
            timeStringBuilder.append('0');
        }
        timeStringBuilder.append(minutes).append(':');
        if (remainingSeconds < 10L) {
            timeStringBuilder.append('0');
        }
        timeStringBuilder.append(remainingSeconds);
        if (isElapsed) {
            timeStringBuilder.append(" elapsed");
        } else {
            timeStringBuilder.append(" left");
        }
        return timeStringBuilder.toString();
    }

    public Map<String, String> getButtonData() {
        Map results = StringUtils.newLinkedHashMap();
        if (this.buttons != null) {
            for (JsonElement button : this.buttons) {
                try {
                    JsonObject buttonObj;
                    if (!button.isJsonObject() || !(buttonObj = button.getAsJsonObject()).has("label") || !buttonObj.has("url")) continue;
                    results.put(buttonObj.get("label").getAsString(), buttonObj.get("url").getAsString());
                }
                catch (Throwable ex) {
                    Constants.LOG.debugError(ex);
                }
            }
        }
        return results;
    }

    public String state(int minPlayers, int maxPlayers) {
        String original = this.state();
        return StringUtils.isNullOrEmpty((String)original) ? original : original + " (" + minPlayers + " of " + maxPlayers + ")";
    }
}

