/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine.io.metadata.strategy.field;

import com.temporal.api.common.block.LogBlock;
import com.temporal.api.core.engine.io.metadata.annotation.BlockModel;
import com.temporal.api.core.engine.io.metadata.strategy.field.FieldAnnotationStrategy;
import com.temporal.api.core.event.data.model.block.BlockStateProvider;
import java.lang.reflect.Field;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.registries.RegistryObject;

public class BlockModelStrategy
implements FieldAnnotationStrategy {
    @Override
    public void execute(Field field, Object object) throws Exception {
        if (field.isAnnotationPresent(BlockModel.class)) {
            field.setAccessible(true);
            RegistryObject registryObject = (RegistryObject)field.get(object);
            BlockModel blockModel = field.getDeclaredAnnotation(BlockModel.class);
            switch (blockModel.type()) {
                case CUBED: {
                    BlockStateProvider.BLOCKS.add((RegistryObject<Block>)registryObject);
                    break;
                }
                case DOOR: {
                    BlockStateProvider.DOORS.add((RegistryObject<DoorBlock>)registryObject);
                    break;
                }
                case BUTTON: {
                    BlockStateProvider.BUTTONS.add((RegistryObject<ButtonBlock>)registryObject);
                    break;
                }
                case FENCE: {
                    BlockStateProvider.FENCES.add((RegistryObject<FenceBlock>)registryObject);
                    break;
                }
                case FENCE_GATE: {
                    BlockStateProvider.FENCE_GATES.add((RegistryObject<FenceGateBlock>)registryObject);
                    break;
                }
                case PRESSURE_PLATE: {
                    BlockStateProvider.PRESSURE_PLATES.add((RegistryObject<PressurePlateBlock>)registryObject);
                    break;
                }
                case TRAPDOOR: {
                    BlockStateProvider.TRAPDOORS.add((RegistryObject<TrapDoorBlock>)registryObject);
                    break;
                }
                case SLAB: {
                    BlockStateProvider.SLABS.add((RegistryObject<SlabBlock>)registryObject);
                    break;
                }
                case STAIRS: {
                    BlockStateProvider.STAIRS.add((RegistryObject<StairBlock>)registryObject);
                    break;
                }
                case WALL: {
                    BlockStateProvider.WALLS.add((RegistryObject<WallBlock>)registryObject);
                    break;
                }
                case LOG: {
                    BlockStateProvider.LOGS.add((RegistryObject<LogBlock>)registryObject);
                    break;
                }
                case ROTATED_PILLAR: {
                    BlockStateProvider.ROTATED_PILLARS.add((RegistryObject<RotatedPillarBlock>)registryObject);
                }
            }
        }
    }
}

