/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.extension.block;

import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.registry.factory.common.BlockFactory;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;

public interface SignExtension {
    default public RegistryObject<?> createStandingSign(String name, float strength, WoodType woodType) {
        BlockFactory factory = InjectionContext.getInstance().getObject(BlockFactory.class);
        return factory.createTyped(name, (Supplier<? extends Block>)((Supplier<Block>)() -> new StandingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(strength).m_278183_(), woodType)));
    }

    default public RegistryObject<?> createHangingSign(String name, MapColor color, float strength, WoodType woodType) {
        BlockFactory factory = InjectionContext.getInstance().getObject(BlockFactory.class);
        return factory.createTyped(name, (Supplier<? extends Block>)((Supplier<Block>)() -> new CeilingHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(strength).m_278183_(), woodType)));
    }

    default public RegistryObject<?> createWallSign(String name, Supplier<Block> dropBlock, float strength, WoodType woodType) {
        BlockFactory factory = InjectionContext.getInstance().getObject(BlockFactory.class);
        return factory.createTyped(name, (Supplier<? extends Block>)((Supplier<Block>)() -> new WallSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().lootFrom(dropBlock).m_60978_(strength).m_278183_(), woodType)));
    }
}

