/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.extension.item;

import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.registry.factory.common.ItemFactory;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public interface FoodExtension {
    default public RegistryObject<Item> createFood(String name, int nutrition, float saturation) {
        return this.createFood(name, new Item.Properties(), nutrition, saturation);
    }

    default public RegistryObject<Item> createFood(String name, int nutrition, float saturation, MobEffect effect, float effectDuration) {
        return this.createFood(name, new Item.Properties(), nutrition, saturation, effect, effectDuration);
    }

    default public RegistryObject<Item> createFood(String name, Item.Properties properties, int nutrition, float saturation) {
        return this.createFood(name, properties, new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38767_());
    }

    default public RegistryObject<Item> createFood(String name, Item.Properties properties, int nutrition, float saturation, MobEffect effect, float effectDuration) {
        return this.createFood(name, properties, new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).effect(() -> new MobEffectInstance(effect), effectDuration).m_38767_());
    }

    default public RegistryObject<Item> createFood(String name, Item.Properties properties, FoodProperties foodProperties) {
        ItemFactory itemFactory = InjectionContext.getInstance().getObject(ItemFactory.class);
        return itemFactory.createTyped(name, (Supplier<? extends Item>)((Supplier<Item>)() -> new Item(properties.m_41489_(foodProperties))));
    }
}

