/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import umpaz.nethersdelight.common.registry.NDBlocks;
import umpaz.nethersdelight.common.registry.NDItems;
import umpaz.nethersdelight.integration.jei.NDRecipeTypes;
import umpaz.nethersdelight.integration.jei.category.CompositionRecipeCategory;
import umpaz.nethersdelight.integration.jei.resource.CompositionDummy;
import vectorwing.farmersdelight.integration.jei.FDRecipes;

@ParametersAreNonnullByDefault
@JeiPlugin
public class NDJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("nethersdelight", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CompositionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        FDRecipes modRecipes = new FDRecipes();
        registration.addRecipes(NDRecipeTypes.COMPOSITION, (List)ImmutableList.of((Object)new CompositionDummy()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDItems.BLACKSTONE_STOVE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDItems.BLACKSTONE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDItems.NETHER_BRICK_SMOKER.get()), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDItems.BLACKSTONE_BLAST_FURNACE.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDBlocks.SOUL_COMPOST.get()), new RecipeType[]{NDRecipeTypes.COMPOSITION});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

