/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.inventory;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;

public interface IInventoryAccess {
    default public int[] getAvailableSlots() {
        return this.getAvailableSlots(null);
    }

    public int[] getAvailableSlots(@Nullable Direction var1);

    public ItemStack getStackInSlot(int var1);

    default public boolean canInsert(int slot, ItemStack stack) {
        return this.canInsert(slot, stack, null);
    }

    default public boolean canInsert(int slot, ItemStack stack, @Nullable Direction side) {
        ItemStack remaining = this.insert(slot, stack, side, false);
        return remaining.m_41613_() < stack.m_41613_();
    }

    default public ItemStack insert(int slot, ItemStack stack) {
        return this.insert(slot, stack, null);
    }

    default public ItemStack insert(int slot, ItemStack stack, @Nullable Direction side) {
        return this.insert(slot, stack, side, true);
    }

    public ItemStack insert(int var1, ItemStack var2, @Nullable Direction var3, boolean var4);

    default public boolean canExtract(int slot, int amount) {
        return this.canExtract(slot, amount, null);
    }

    default public boolean canExtract(int slot, int amount, @Nullable Direction side) {
        return !this.extract(slot, amount, side, false).m_41619_();
    }

    default public ItemStack extract(int slot, int amount) {
        return this.extract(slot, amount, null);
    }

    default public ItemStack extract(int slot, int amount, @Nullable Direction side) {
        return this.extract(slot, amount, side, true);
    }

    public ItemStack extract(int var1, int var2, @Nullable Direction var3, boolean var4);

    public int getSlotSize(int var1);

    default public boolean isValidForSlot(int slot, ItemStack stack) {
        return this.isValidForSlot(slot, stack, null);
    }

    public boolean isValidForSlot(int var1, ItemStack var2, @Nullable Direction var3);

    default public void forEachSlot(IntConsumer slotAction, @Nullable Direction side) {
        for (int slotId : this.getAvailableSlots(side)) {
            slotAction.accept(slotId);
        }
    }
}

