/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.api;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import org.jetbrains.annotations.Nullable;

public final class MoobloomVariantManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final MoobloomVariant DEFAULT_MOOBLOOM_VARIANT = new MoobloomVariant("buttercup", FriendsAndFoesBlocks.BUTTERCUP.get(), FriendsAndFoesTags.HAS_MOOBLOOMS);
    public static final MoobloomVariantManager MOOBLOOM_VARIANT_MANAGER = new MoobloomVariantManager();
    private List<MoobloomVariant> moobloomVariants = new ArrayList<MoobloomVariant>(){
        {
            this.add(DEFAULT_MOOBLOOM_VARIANT);
        }
    };

    private MoobloomVariantManager() {
        super(GSON, "moobloom_variants");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        ArrayList<MoobloomVariant> parsedMoobloomVariants = new ArrayList<MoobloomVariant>();
        parsedMoobloomVariants.add(DEFAULT_MOOBLOOM_VARIANT);
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                JsonObject jsonObject = (JsonObject)GSON.fromJson((JsonElement)jsonElement.getAsJsonObject(), JsonObject.class);
                if (jsonObject != null) {
                    String name = jsonObject.get("name").getAsString();
                    String flowerBlockRaw = jsonObject.get("flower_block").getAsString();
                    BushBlock flowerBlock = (BushBlock)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(flowerBlockRaw));
                    String biomes = jsonObject.get("biomes").getAsString();
                    TagKey biomesValue = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomes.replaceFirst("#", "")));
                    parsedMoobloomVariants.add(new MoobloomVariant(name, (Block)flowerBlock, (TagKey<Biome>)biomesValue));
                }
            }
            catch (Exception e) {
                FriendsAndFoes.getLogger().error("Friends&Foes Error: Couldn't parse moobloom variant {}", fileIdentifier, (Object)e);
            }
        });
        this.setMoobloomVariants(parsedMoobloomVariants);
    }

    public void setMoobloomVariants(List<MoobloomVariant> moobloomVariants) {
        this.moobloomVariants = moobloomVariants;
    }

    public List<MoobloomVariant> getMoobloomVariants() {
        return this.moobloomVariants;
    }

    public MoobloomVariant getDefaultMoobloomVariant() {
        return this.getMoobloomVariantByName(DEFAULT_MOOBLOOM_VARIANT.getName());
    }

    public MoobloomVariant getRandomMoobloomVariant(RandomSource random) {
        Object[] values = this.getMoobloomVariants().toArray();
        int min = 0;
        int max = values.length - 1;
        return (MoobloomVariant)values[random.m_188503_(max - min + 1) + min];
    }

    @Nullable
    public MoobloomVariant getMoobloomVariantByName(String name) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!Objects.equals(moobloomVariant.getName(), name)) continue;
            return moobloomVariant;
        }
        return null;
    }

    @Nullable
    public MoobloomVariant getRandomBiomeSpecificMoobloomVariant(ServerLevelAccessor serverWorldAccess, BlockPos blockPos) {
        ArrayList<MoobloomVariant> possibleMoobloomVariants = new ArrayList<MoobloomVariant>();
        Holder biome = serverWorldAccess.m_204166_(blockPos);
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!biome.m_203656_(moobloomVariant.getBiomes())) continue;
            possibleMoobloomVariants.add(moobloomVariant);
        }
        if (possibleMoobloomVariants.isEmpty()) {
            return null;
        }
        return (MoobloomVariant)possibleMoobloomVariants.get(serverWorldAccess.m_213780_().m_188503_(possibleMoobloomVariants.size()));
    }

    @Nullable
    public MoobloomVariant getByFlowerItem(Item flowerItem) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (moobloomVariant.getFlowerAsItem() != flowerItem) continue;
            return moobloomVariant;
        }
        return null;
    }
}

