/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.forge.citresewn;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import shcm.shsupercm.forge.citresewn.CITResewn;
import shcm.shsupercm.forge.citresewn.config.CITResewnConfig;
import shcm.shsupercm.forge.citresewn.pack.CITPack;
import shcm.shsupercm.forge.citresewn.pack.cits.CIT;
import shcm.shsupercm.forge.citresewn.pack.cits.CITArmor;
import shcm.shsupercm.forge.citresewn.pack.cits.CITElytra;
import shcm.shsupercm.forge.citresewn.pack.cits.CITEnchantment;
import shcm.shsupercm.forge.citresewn.pack.cits.CITItem;

public class ActiveCITs {
    public final List<CITPack> packs;
    public final CITPack effectiveGlobalProperties = new CITPack(null);
    public final List<CIT> cits;
    public final Map<Item, List<CITItem>> citItems = new HashMap<Item, List<CITItem>>();
    public final Map<ArmorItem, List<CITArmor>> citArmor = new HashMap<ArmorItem, List<CITArmor>>();
    public final List<CITElytra> citElytra = new ArrayList<CITElytra>();
    public final List<List<CITEnchantment>> citEnchantments = new ArrayList<List<CITEnchantment>>();

    public ActiveCITs(List<CITPack> packs, List<CIT> cits) {
        this.packs = packs;
        this.cits = cits;
        for (CITPack pack : packs) {
            this.effectiveGlobalProperties.loadGlobalProperties(pack);
        }
        for (CITPack pack : packs) {
            pack.loadGlobalProperties(this.effectiveGlobalProperties);
        }
        TreeMap<Integer, List> citEnchantmentLayers = new TreeMap<Integer, List>();
        for (CIT cit2 : cits.stream().sorted(Comparator.comparingInt(cit -> cit.weight).reversed().thenComparing(cit -> cit.propertiesIdentifier.toString())).collect(Collectors.toList())) {
            if (cit2 instanceof CITItem) {
                CITItem item = (CITItem)cit2;
                for (Item type : item.items) {
                    this.citItems.computeIfAbsent(type, t -> new ArrayList()).add(item);
                }
                continue;
            }
            if (cit2 instanceof CITArmor) {
                CITArmor armor = (CITArmor)cit2;
                for (Item type : armor.items) {
                    if (type instanceof ArmorItem) {
                        ArmorItem armorType = (ArmorItem)type;
                        this.citArmor.computeIfAbsent(armorType, t -> new ArrayList()).add(armor);
                        continue;
                    }
                    CITResewn.logErrorLoading("Ignoring item type: " + BuiltInRegistries.f_257033_.m_7981_((Object)type) + " is not armor in " + cit2.pack.resourcePack.m_5542_() + " -> " + cit2.propertiesIdentifier.toString());
                }
                continue;
            }
            if (cit2 instanceof CITElytra) {
                CITElytra elytra = (CITElytra)cit2;
                this.citElytra.add(elytra);
                continue;
            }
            if (!(cit2 instanceof CITEnchantment)) continue;
            CITEnchantment enchantment = (CITEnchantment)cit2;
            citEnchantmentLayers.computeIfAbsent(enchantment.layer, l -> new ArrayList()).add(enchantment);
        }
        for (List layer : citEnchantmentLayers.values()) {
            for (CITEnchantment enchantment : layer) {
                enchantment.activate();
            }
            this.citEnchantments.add(layer);
        }
    }

    public void dispose() {
        for (CIT cit : this.cits) {
            cit.dispose();
        }
        this.cits.clear();
        this.citItems.clear();
        this.citArmor.clear();
        this.citElytra.clear();
        this.citEnchantments.clear();
    }

    public CITItem getCITItem(ItemStack stack, Level world, LivingEntity entity) {
        InteractionHand hand = entity != null && stack == entity.m_21206_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ((CITItem.Cached)stack).citresewn_setMojankCIT(false);
        List<CITItem> citItems = this.citItems.get(stack.m_41720_());
        if (citItems != null) {
            for (CITItem citItem : citItems) {
                if (!citItem.test(stack, hand, world, entity, true)) continue;
                if (stack.m_150930_(Items.f_42713_) || stack.m_150930_(Items.f_151059_)) {
                    ((CITItem.Cached)stack).citresewn_setMojankCIT(true);
                }
                return citItem;
            }
        }
        return null;
    }

    public CITElytra getCITElytra(ItemStack stack, Level world, LivingEntity livingEntity) {
        for (CITElytra citElytra : this.citElytra) {
            if (!citElytra.test(stack, InteractionHand.MAIN_HAND, world, livingEntity, true)) continue;
            return citElytra;
        }
        return null;
    }

    public CITArmor getCITArmor(ItemStack stack, Level world, LivingEntity livingEntity) {
        List<CITArmor> citArmor;
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && (citArmor = this.citArmor.get(item)) != null) {
            for (CITArmor armor : citArmor) {
                if (!armor.test(stack, null, world, livingEntity, true)) continue;
                return armor;
            }
        }
        return null;
    }

    public List<CITEnchantment> getCITEnchantment(ItemStack stack, Level world, LivingEntity livingEntity) {
        InteractionHand hand = livingEntity != null && stack == livingEntity.m_21206_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ArrayList<CITEnchantment> applied = new ArrayList<CITEnchantment>();
        block0: for (List<CITEnchantment> layer : this.citEnchantments) {
            for (CITEnchantment cit : layer) {
                if (!cit.test(stack, hand, world, livingEntity, false)) continue;
                applied.add(cit);
                continue block0;
            }
        }
        return applied;
    }

    public BakedModel getItemModelCached(ItemStack stack, Level world, LivingEntity entity, int seed) {
        CITItem citItem;
        BakedModel bakedModel = null;
        Supplier<CITItem> realtime = () -> this.getCITItem(stack, world, entity);
        CITItem cITItem = citItem = CITResewnConfig.INSTANCE().cache_ms == 0 ? realtime.get() : ((CITItem.Cached)stack).citresewn_getCachedCITItem(realtime);
        if (citItem != null) {
            bakedModel = citItem.getItemModel(stack, (ClientLevel)world, entity, seed);
        }
        return bakedModel;
    }

    public ResourceLocation getElytraTextureCached(ItemStack stack, Level world, LivingEntity livingEntity) {
        CITElytra citElytra;
        Supplier<CITElytra> realtime = () -> this.getCITElytra(stack, world, livingEntity);
        CITElytra cITElytra = citElytra = CITResewnConfig.INSTANCE().cache_ms == 0 ? realtime.get() : ((CITElytra.Cached)stack).citresewn_getCachedCITElytra(realtime);
        if (citElytra != null) {
            return citElytra.textureIdentifier;
        }
        return null;
    }

    public Map<String, ResourceLocation> getArmorTexturesCached(ItemStack stack, Level world, LivingEntity livingEntity) {
        CITArmor citArmor;
        Supplier<CITArmor> realtime = () -> this.getCITArmor(stack, world, livingEntity);
        CITArmor cITArmor = citArmor = CITResewnConfig.INSTANCE().cache_ms == 0 ? realtime.get() : ((CITArmor.Cached)stack).citresewn_getCachedCITArmor(realtime);
        if (citArmor != null) {
            return citArmor.textures;
        }
        return null;
    }

    public void setEnchantmentAppliedContextCached(ItemStack stack, Level world, LivingEntity entity) {
        List<CITEnchantment> citEnchantments;
        if (stack == null) {
            CITEnchantment.appliedContext = null;
            return;
        }
        Supplier<List<CITEnchantment>> realtime = () -> this.getCITEnchantment(stack, world, entity);
        List<CITEnchantment> list = citEnchantments = CITResewnConfig.INSTANCE().cache_ms == 0 ? realtime.get() : ((CITEnchantment.Cached)stack).citresewn_getCachedCITEnchantment(realtime);
        if (citEnchantments == null || citEnchantments.isEmpty()) {
            CITEnchantment.appliedContext = null;
            return;
        }
        if (this.effectiveGlobalProperties.method != null) {
            this.effectiveGlobalProperties.method.applyMethod(citEnchantments, stack);
        }
        CITEnchantment.appliedContext = citEnchantments;
    }
}

