/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.forge.citresewn.pack;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.apache.commons.lang3.StringUtils;
import shcm.shsupercm.forge.citresewn.CITResewn;
import shcm.shsupercm.forge.citresewn.ex.CITParseException;
import shcm.shsupercm.forge.citresewn.pack.CITPack;
import shcm.shsupercm.forge.citresewn.pack.cits.CIT;
import shcm.shsupercm.forge.citresewn.pack.cits.CITArmor;
import shcm.shsupercm.forge.citresewn.pack.cits.CITElytra;
import shcm.shsupercm.forge.citresewn.pack.cits.CITEnchantment;
import shcm.shsupercm.forge.citresewn.pack.cits.CITItem;

public final class CITParser {
    public static final Map<String, CITConstructor> REGISTRY = new HashMap<String, CITConstructor>();
    public static final String[] ROOTS;

    private CITParser() {
    }

    public static List<CITPack> parseCITs(Collection<PackResources> packs) {
        ArrayList<CITPack> list = new ArrayList<CITPack>();
        for (PackResources pack : packs) {
            Collection<CITPack> parse = CITParser.parse(pack);
            for (CITPack citPack : parse) {
                list.add(citPack);
            }
        }
        return list;
    }

    public static Collection<CITPack> parse(PackResources resourcePack) {
        CITPack citPack = new CITPack(resourcePack);
        ArrayList packProperties = new ArrayList();
        for (String namespace : resourcePack.m_5698_(PackType.CLIENT_RESOURCES)) {
            if (!ResourceLocation.m_135830_((String)namespace)) continue;
            for (String citRoot : ROOTS) {
                ArrayList locations = new ArrayList();
                resourcePack.m_8031_(PackType.CLIENT_RESOURCES, namespace, citRoot + "/cit", (resourceLocation, inputStreamIoSupplier) -> {
                    if (resourceLocation.m_135815_().endsWith(".properties")) {
                        locations.add(resourceLocation);
                    }
                });
                packProperties.addAll(locations);
                ResourceLocation global = new ResourceLocation(namespace, citRoot + "/cit.properties");
                if (resourcePack.m_214146_(PackType.CLIENT_RESOURCES, global) == null) continue;
                packProperties.add(global);
            }
        }
        boolean readGlobalProperties = false;
        Iterator iterator = packProperties.iterator();
        while (iterator.hasNext()) {
            ResourceLocation propertiesIdentifier = (ResourceLocation)iterator.next();
            try {
                if (StringUtils.countMatches((CharSequence)propertiesIdentifier.m_135815_(), (char)'/') > 2 || !propertiesIdentifier.m_135815_().endsWith("cit.properties")) continue;
                iterator.remove();
                if (readGlobalProperties) continue;
                InputStream is = (InputStream)resourcePack.m_214146_(PackType.CLIENT_RESOURCES, propertiesIdentifier).m_247737_();
                try {
                    Properties citProperties = new Properties();
                    citProperties.load(is);
                    citPack.loadGlobalProperties(citProperties);
                    readGlobalProperties = true;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                CITResewn.logErrorLoading("Skipped global properties: " + e.getMessage() + " in " + resourcePack.m_5542_() + " -> " + propertiesIdentifier);
            }
        }
        packProperties.stream().flatMap(citIdentifier -> {
            Stream<CIT> stream;
            block9: {
                InputStream is = (InputStream)resourcePack.m_214146_(PackType.CLIENT_RESOURCES, citIdentifier).m_247737_();
                try {
                    Properties citProperties = new Properties();
                    citProperties.load(new InputStreamReader(is, StandardCharsets.UTF_8));
                    CITConstructor type = REGISTRY.get(citProperties.getProperty("type", "item"));
                    if (type == null) {
                        throw new CITParseException(citPack.resourcePack, (ResourceLocation)citIdentifier, "Unknown cit type \"" + citProperties.getProperty("type") + "\"");
                    }
                    stream = Stream.of(type.cit(citPack, (ResourceLocation)citIdentifier, citProperties));
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        CITResewn.logErrorLoading(e.getMessage());
                        return Stream.empty();
                    }
                }
                is.close();
            }
            return stream;
        }).collect(Collectors.toCollection(() -> citPack.cits));
        if (citPack.cits.isEmpty()) {
            return Collections.emptySet();
        }
        CITResewn.info("Found " + citPack.cits.size() + " CIT" + (citPack.cits.size() == 1 ? "" : "s") + " in " + resourcePack.m_5542_());
        return Collections.singleton(citPack);
    }

    static {
        REGISTRY.put("item", CITItem::new);
        REGISTRY.put("armor", CITArmor::new);
        REGISTRY.put("elytra", CITElytra::new);
        REGISTRY.put("enchantment", CITEnchantment::new);
        ROOTS = new String[]{"citresewn", "optifine", "mcpatcher"};
    }

    public static interface CITConstructor {
        public CIT cit(CITPack var1, ResourceLocation var2, Properties var3) throws CITParseException;
    }
}

