/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.forge.citresewn.pack.cits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import shcm.shsupercm.forge.citresewn.CITResewn;
import shcm.shsupercm.forge.citresewn.ex.CITParseException;
import shcm.shsupercm.forge.citresewn.mixin.core.NbtCompoundAccessor;
import shcm.shsupercm.forge.citresewn.pack.CITPack;

public abstract class CIT {
    public final CITPack pack;
    public final ResourceLocation propertiesIdentifier;
    public final Set<Item> items = new HashSet<Item>();
    public final int damageMin;
    public final int damageMax;
    public final boolean damageAny;
    public final boolean damageRange;
    public final boolean damagePercentage;
    public final Integer damageMask;
    public final int stackMin;
    public final int stackMax;
    public final boolean stackAny;
    public final boolean stackRange;
    public final Set<ResourceLocation> enchantments = new HashSet<ResourceLocation>();
    public final List<Tuple<Integer, Integer>> enchantmentLevels = new ArrayList<Tuple<Integer, Integer>>();
    public final boolean enchantmentsAny;
    public final boolean enchantmentLevelsAny;
    public final InteractionHand hand;
    public final Predicate<CompoundTag> nbt;
    public final int weight;

    public CIT(CITPack pack, ResourceLocation identifier, Properties properties) throws CITParseException {
        this.pack = pack;
        this.propertiesIdentifier = identifier;
        try {
            String string;
            String damage;
            for (String string2 : properties.getProperty("items", properties.getProperty("matchItems", " ")).split(" ")) {
                if (string2.isEmpty()) continue;
                ResourceLocation itemIdentifier = new ResourceLocation(string2);
                if (!BuiltInRegistries.f_257033_.m_7804_(itemIdentifier)) {
                    throw new Exception("Unknown item " + string2);
                }
                this.items.add((Item)BuiltInRegistries.f_257033_.m_7745_(itemIdentifier));
            }
            if (this.items.isEmpty()) {
                try {
                    String id = this.propertiesIdentifier.m_135815_().substring(0, this.propertiesIdentifier.m_135815_().length() - 11);
                    String[] split = id.split("/");
                    id = split[split.length - 1];
                    ResourceLocation itemId = new ResourceLocation(this.propertiesIdentifier.m_135827_(), id);
                    if (BuiltInRegistries.f_257033_.m_7804_(itemId)) {
                        this.items.add((Item)BuiltInRegistries.f_257033_.m_7745_(itemId));
                    }
                }
                catch (Exception id) {
                    // empty catch block
                }
            }
            if (this.damageAny = (damage = properties.getProperty("damage")) == null) {
                this.damageRange = false;
                this.damagePercentage = false;
                this.damageMin = 0;
                this.damageMax = 0;
            } else {
                this.damagePercentage = damage.contains("%");
                if (this.damagePercentage) {
                    damage = damage.replace("%", "");
                }
                if (damage.contains("-")) {
                    String[] split = damage.split("-");
                    if (split.length > 2) {
                        throw new Exception("damage range must have up to 2 numbers");
                    }
                    this.damageMin = split[0].isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(split[0]);
                    int n = this.damageMax = split.length == 1 ? Integer.MAX_VALUE : Integer.parseInt(split[1]);
                    if (this.damageMin > this.damageMax) {
                        throw new Exception("damage range min is higher than max");
                    }
                    this.damageRange = this.damageMin < this.damageMax;
                } else {
                    this.damageRange = false;
                    this.damageMin = this.damageMax = Integer.parseInt(damage);
                }
            }
            this.damageMask = properties.containsKey("damageMask") ? Integer.valueOf(Integer.parseInt(properties.getProperty("damageMask"))) : null;
            String stackSize = properties.getProperty("stackSize");
            this.stackAny = stackSize == null;
            if (this.stackAny) {
                this.stackRange = false;
                this.stackMin = 0;
                this.stackMax = 0;
            } else if (stackSize.contains("-")) {
                String[] split = stackSize.split("-");
                if (split.length > 2) {
                    throw new Exception("stackSize range must have up to 2 numbers");
                }
                this.stackMin = split[0].isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(split[0]);
                int n = this.stackMax = split.length == 1 ? Integer.MAX_VALUE : Integer.parseInt(split[1]);
                if (this.stackMin > this.stackMax) {
                    throw new Exception("stackSize range min is higher than max");
                }
                this.stackRange = this.stackMin < this.stackMax;
            } else {
                this.stackRange = false;
                this.stackMin = this.stackMax = Integer.parseInt(stackSize);
            }
            String enchantmentIDs = properties.getProperty("enchantments", properties.getProperty("enchantmentIDs"));
            this.enchantmentsAny = enchantmentIDs == null;
            if (!this.enchantmentsAny) {
                for (String ench : enchantmentIDs.split(" ")) {
                    ResourceLocation enchIdentifier = new ResourceLocation(ench);
                    if (!BuiltInRegistries.f_256876_.m_7804_(enchIdentifier)) {
                        CITResewn.logWarnLoading("CIT Warning: Unknown enchantment " + enchIdentifier);
                    }
                    this.enchantments.add(enchIdentifier);
                }
            }
            if (!(this.enchantmentLevelsAny = (string = properties.getProperty("enchantmentLevels")) == null)) {
                for (String range : string.split(" ")) {
                    if (range.contains("-")) {
                        if (range.startsWith("-")) {
                            if ((range = range.substring(1)).contains("-")) {
                                throw new Exception("enchantmentLevels ranges must have up to 2 numbers each");
                            }
                            this.enchantmentLevels.add((Tuple<Integer, Integer>)new Tuple((Object)0, (Object)Integer.parseInt(range)));
                            continue;
                        }
                        if (range.endsWith("-")) {
                            if ((range = range.substring(0, range.length() - 1)).contains("-")) {
                                throw new Exception("enchantmentLevels ranges must have up to 2 numbers each");
                            }
                            this.enchantmentLevels.add((Tuple<Integer, Integer>)new Tuple((Object)Integer.parseInt(range), (Object)Integer.MAX_VALUE));
                            continue;
                        }
                        String[] split = range.split("-");
                        if (split.length != 2) {
                            throw new Exception("enchantmentLevels ranges must have up to 2 numbers each");
                        }
                        Tuple minMaxPair = new Tuple((Object)Integer.parseInt(split[0]), (Object)Integer.parseInt(split[1]));
                        if ((Integer)minMaxPair.m_14418_() > (Integer)minMaxPair.m_14419_()) {
                            throw new Exception("enchantmentLevels range min is higher than max");
                        }
                        this.enchantmentLevels.add((Tuple<Integer, Integer>)minMaxPair);
                        continue;
                    }
                    int level = Integer.parseInt(range);
                    this.enchantmentLevels.add((Tuple<Integer, Integer>)new Tuple((Object)level, (Object)level));
                }
            }
            this.hand = switch (properties.getProperty("hand", "any")) {
                case "main" -> InteractionHand.MAIN_HAND;
                case "off" -> InteractionHand.OFF_HAND;
                default -> null;
            };
            ArrayList<1> nbtPredicates = new ArrayList<1>();
            for (Object o : properties.keySet()) {
                Predicate<String> match;
                String property;
                if (!(o instanceof String) || !(property = (String)o).startsWith("nbt.")) continue;
                String matchProperty = properties.getProperty(property);
                final String[] path = property.substring(4).split("\\.");
                boolean caseSensitive = !matchProperty.startsWith("i");
                if (matchProperty.startsWith(caseSensitive ? "pattern:" : "ipattern:")) {
                    matchProperty = caseSensitive ? matchProperty.substring(8) : matchProperty.substring(9).toLowerCase(Locale.ENGLISH);
                    pattern = matchProperty;
                    match = arg_0 -> CIT.lambda$new$0(caseSensitive, (String)pattern, arg_0);
                } else if (matchProperty.startsWith(caseSensitive ? "regex:" : "iregex:")) {
                    matchProperty = caseSensitive ? matchProperty.substring(6) : matchProperty.substring(7).toLowerCase(Locale.ENGLISH);
                    pattern = Pattern.compile(matchProperty);
                    match = arg_0 -> CIT.lambda$new$1((Pattern)pattern, caseSensitive, arg_0);
                } else {
                    if (property.equals("nbt.display.color") && matchProperty.startsWith("#")) {
                        try {
                            matchProperty = String.valueOf(Integer.parseInt(matchProperty.substring(1).toLowerCase(Locale.ENGLISH), 16));
                        }
                        catch (Exception pattern) {
                            // empty catch block
                        }
                    }
                    pattern = matchProperty;
                    match = arg_0 -> CIT.lambda$new$2((String)pattern, arg_0);
                }
                final boolean checkJson = (path[path.length - 1].equals("Name") || path.length >= 2 && path[path.length - 2].equals("Lore")) && (!matchProperty.startsWith("{") && !matchProperty.startsWith("\\{") || !matchProperty.endsWith("}"));
                nbtPredicates.add(new Predicate<CompoundTag>(){

                    public boolean test(Tag nbtElement, int index) {
                        if (index >= path.length) {
                            if (nbtElement instanceof StringTag) {
                                StringTag nbtString = (StringTag)nbtElement;
                                String text = nbtString.m_7916_();
                                if (checkJson) {
                                    try {
                                        text = Component.Serializer.m_130701_((String)text).getString();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return match.test(text);
                            }
                            if (nbtElement instanceof NumericTag) {
                                NumericTag nbtNumber = (NumericTag)nbtElement;
                                return match.test(String.valueOf(nbtNumber.m_8103_()));
                            }
                        } else {
                            String name = path[index];
                            if (name.equals("*")) {
                                if (nbtElement instanceof CompoundTag) {
                                    CompoundTag nbtCompound = (CompoundTag)nbtElement;
                                    for (Tag subElement : ((NbtCompoundAccessor)nbtCompound).getTags().values()) {
                                        if (!this.test(subElement, index + 1)) continue;
                                        return true;
                                    }
                                } else if (nbtElement instanceof ListTag) {
                                    ListTag nbtList = (ListTag)nbtElement;
                                    for (Tag subElement : nbtList) {
                                        if (!this.test(subElement, index + 1)) continue;
                                        return true;
                                    }
                                }
                            } else {
                                if (nbtElement instanceof CompoundTag) {
                                    CompoundTag nbtCompound = (CompoundTag)nbtElement;
                                    Tag subElement = nbtCompound.m_128423_(name);
                                    return subElement != null && this.test(subElement, index + 1);
                                }
                                if (nbtElement instanceof ListTag) {
                                    ListTag nbtList = (ListTag)nbtElement;
                                    try {
                                        Tag subElement = nbtList.get(Integer.parseInt(name));
                                        return subElement != null && this.test(subElement, index + 1);
                                    }
                                    catch (Exception ignored) {
                                        return false;
                                    }
                                }
                            }
                        }
                        return false;
                    }

                    @Override
                    public boolean test(CompoundTag nbtCompound) {
                        return this.test((Tag)nbtCompound, 0);
                    }
                });
            }
            this.nbt = nbtCompound -> {
                for (Predicate predicate : nbtPredicates) {
                    if (predicate.test(nbtCompound)) continue;
                    return false;
                }
                return true;
            };
            this.weight = Integer.parseInt(properties.getProperty("weight", "0"));
        }
        catch (Exception e) {
            throw new CITParseException(pack.resourcePack, identifier, (String)(e.getClass() == Exception.class ? "" : e.getClass().getSimpleName() + ": ") + e.getMessage());
        }
    }

    public boolean test(ItemStack stack, InteractionHand hand, Level world, LivingEntity entity, boolean ignoreItemType) {
        if (!(ignoreItemType || this.items.isEmpty() || this.items.contains(stack.m_41720_()))) {
            return false;
        }
        if (!this.damageAny && stack.m_41720_().m_41465_()) {
            int damage = stack.m_41773_();
            if (this.damageMask != null) {
                damage &= this.damageMask.intValue();
            }
            if (this.damagePercentage) {
                damage = Math.round(100.0f * (float)stack.m_41773_() / (float)stack.m_41776_());
            }
            if (this.damageRange ? damage < this.damageMin || damage > this.damageMax : damage != this.damageMin) {
                return false;
            }
        }
        if (!this.stackAny) {
            int count = stack.m_41613_();
            if (this.stackRange ? count < this.stackMin || count > this.stackMax : count != this.stackMin) {
                return false;
            }
        }
        if (this.hand != null && this.hand != hand) {
            return false;
        }
        if (!this.enchantmentsAny) {
            LinkedHashMap<ResourceLocation, Integer> stackEnchantments = new LinkedHashMap<ResourceLocation, Integer>();
            for (Object nbtElement : stack.m_150930_(Items.f_42690_) ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_()) {
                stackEnchantments.put(EnchantmentHelper.m_182446_((CompoundTag)((CompoundTag)nbtElement)), EnchantmentHelper.m_182438_((CompoundTag)((CompoundTag)nbtElement)));
            }
            boolean matches = false;
            block1: for (ResourceLocation enchantment : this.enchantments) {
                Integer level = (Integer)stackEnchantments.get(enchantment);
                if (level == null) continue;
                if (this.enchantmentLevelsAny) {
                    if (level <= 0) continue;
                    matches = true;
                    break;
                }
                for (Tuple<Integer, Integer> levelRange : this.enchantmentLevels) {
                    if (level < (Integer)levelRange.m_14418_() || level > (Integer)levelRange.m_14419_()) continue;
                    matches = true;
                    continue block1;
                }
            }
            if (!matches) {
                return false;
            }
        } else if (!this.enchantmentLevelsAny) {
            ArrayList<Integer> levels = new ArrayList<Integer>();
            levels.add(0);
            for (Tag nbtElement : stack.m_150930_(Items.f_42690_) ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_()) {
                levels.add(EnchantmentHelper.m_182438_((CompoundTag)((CompoundTag)nbtElement)));
            }
            boolean matches = false;
            block4: for (Integer level : levels) {
                for (Tuple<Integer, Integer> levelRange : this.enchantmentLevels) {
                    if (level < (Integer)levelRange.m_14418_() || level > (Integer)levelRange.m_14419_()) continue;
                    matches = true;
                    break block4;
                }
            }
            if (!matches) {
                return false;
            }
        }
        return this.nbt == null || this.nbt.test(stack.m_41783_());
    }

    public void dispose() {
    }

    public static ResourceLocation resolvePath(ResourceLocation propertyIdentifier, String path, String extension, ResourceManager resourceManager) {
        Predicate<ResourceLocation> packContains = id -> resourceManager.m_213713_(id).isPresent();
        if (path == null) {
            ResourceLocation pathIdentifier;
            path = propertyIdentifier.m_135815_().substring(0, propertyIdentifier.m_135815_().length() - 11);
            if (!((String)path).endsWith(extension)) {
                path = (String)path + extension;
            }
            return packContains.test(pathIdentifier = new ResourceLocation(propertyIdentifier.m_135827_(), (String)path)) ? pathIdentifier : null;
        }
        ResourceLocation pathIdentifier = new ResourceLocation((String)path);
        if (!((String)(path = pathIdentifier.m_135815_().replace('\\', '/'))).endsWith(extension)) {
            path = (String)path + extension;
        }
        if (((String)path).startsWith("./")) {
            path = ((String)path).substring(2);
        } else if (!((String)path).contains("..")) {
            int sep;
            if (packContains.test(pathIdentifier = new ResourceLocation(pathIdentifier.m_135827_(), (String)path))) {
                return pathIdentifier;
            }
            if (((String)path).startsWith("assets/") && packContains.test(pathIdentifier = new ResourceLocation(((String)(path = ((String)path).substring(7))).substring(0, sep = ((String)path).indexOf(47)), ((String)path).substring(sep + 1)))) {
                return pathIdentifier;
            }
            String string = pathIdentifier.m_135827_();
            pathIdentifier = new ResourceLocation(string, (switch (extension) {
                case ".png" -> "textures/";
                case ".json" -> "models/";
                default -> "";
            }) + (String)path);
            if (packContains.test(pathIdentifier)) {
                return pathIdentifier;
            }
        }
        LinkedList<String> pathParts = new LinkedList<String>(Arrays.asList(propertyIdentifier.m_135815_().split("/")));
        pathParts.removeLast();
        if (((String)path).contains("/")) {
            for (String part : ((String)path).split("/")) {
                if (part.equals("..")) {
                    if (pathParts.size() == 0) {
                        return null;
                    }
                    pathParts.removeLast();
                    continue;
                }
                pathParts.addLast(part);
            }
        } else {
            pathParts.addLast((String)path);
        }
        path = String.join((CharSequence)"/", pathParts);
        pathIdentifier = new ResourceLocation(propertyIdentifier.m_135827_(), (String)path);
        return packContains.test(pathIdentifier) ? pathIdentifier : null;
    }

    public static ResourceLocation resolvePath1(ResourceLocation propertyIdentifier, String path, String extension, CITPack citPack) {
        Predicate<ResourceLocation> packContains = id -> citPack.resourcePack.m_214146_(PackType.CLIENT_RESOURCES, id) != null;
        if (path == null) {
            ResourceLocation pathIdentifier;
            path = propertyIdentifier.m_135815_().substring(0, propertyIdentifier.m_135815_().length() - 11);
            if (!((String)path).endsWith(extension)) {
                path = (String)path + extension;
            }
            return packContains.test(pathIdentifier = new ResourceLocation(propertyIdentifier.m_135827_(), (String)path)) ? pathIdentifier : null;
        }
        ResourceLocation pathIdentifier = new ResourceLocation((String)path);
        if (!((String)(path = pathIdentifier.m_135815_().replace('\\', '/'))).endsWith(extension)) {
            path = (String)path + extension;
        }
        if (((String)path).startsWith("./")) {
            path = ((String)path).substring(2);
        } else if (!((String)path).contains("..")) {
            int sep;
            if (packContains.test(pathIdentifier = new ResourceLocation(pathIdentifier.m_135827_(), (String)path))) {
                return pathIdentifier;
            }
            if (((String)path).startsWith("assets/") && packContains.test(pathIdentifier = new ResourceLocation(((String)(path = ((String)path).substring(7))).substring(0, sep = ((String)path).indexOf(47)), ((String)path).substring(sep + 1)))) {
                return pathIdentifier;
            }
            String string = pathIdentifier.m_135827_();
            pathIdentifier = new ResourceLocation(string, (switch (extension) {
                case ".png" -> "textures/";
                case ".json" -> "models/";
                default -> "";
            }) + (String)path);
            if (packContains.test(pathIdentifier)) {
                return pathIdentifier;
            }
        }
        LinkedList<String> pathParts = new LinkedList<String>(Arrays.asList(propertyIdentifier.m_135815_().split("/")));
        pathParts.removeLast();
        if (((String)path).contains("/")) {
            for (String part : ((String)path).split("/")) {
                if (part.equals("..")) {
                    if (pathParts.size() == 0) {
                        return null;
                    }
                    pathParts.removeLast();
                    continue;
                }
                pathParts.addLast(part);
            }
        } else {
            pathParts.addLast((String)path);
        }
        path = String.join((CharSequence)"/", pathParts);
        pathIdentifier = new ResourceLocation(propertyIdentifier.m_135827_(), (String)path);
        return packContains.test(pathIdentifier) ? pathIdentifier : null;
    }

    public static boolean matchesPattern(String value, String pattern, int curV, int maxV, int curG, int maxG) {
        while (curG < maxG) {
            char g = pattern.charAt(curG);
            if (g == '*') {
                while (true) {
                    if (CIT.matchesPattern(value, pattern, curV, maxV, curG + 1, maxG)) {
                        return true;
                    }
                    if (curV >= maxV) break;
                    ++curV;
                }
                return false;
            }
            if (curV >= maxV) break;
            if (g != '?') {
                if (g == '\\' && curG + 1 < maxG) {
                    g = pattern.charAt(++curG);
                }
                if (g != value.charAt(curV)) {
                    return false;
                }
            }
            ++curG;
            ++curV;
        }
        return curG == maxG && curV == maxV;
    }

    private static /* synthetic */ boolean lambda$new$2(String pattern, String s) {
        return s.equals(pattern);
    }

    private static /* synthetic */ boolean lambda$new$1(Pattern pattern, boolean caseSensitive, String s) {
        return pattern.matcher(caseSensitive ? s : s.toLowerCase()).matches();
    }

    private static /* synthetic */ boolean lambda$new$0(boolean caseSensitive, String pattern, String s) {
        return CIT.matchesPattern(caseSensitive ? s : s.toLowerCase(), pattern, 0, s.length(), 0, pattern.length());
    }
}

