/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.forge.citresewn.pack.cits;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.io.IOUtils;
import shcm.shsupercm.forge.citresewn.CITResewn;
import shcm.shsupercm.forge.citresewn.ex.CITLoadException;
import shcm.shsupercm.forge.citresewn.ex.CITParseException;
import shcm.shsupercm.forge.citresewn.mixin.cititem.JsonUnbakedModelAccessor;
import shcm.shsupercm.forge.citresewn.pack.CITPack;
import shcm.shsupercm.forge.citresewn.pack.ResewnItemModelIdentifier;
import shcm.shsupercm.forge.citresewn.pack.cits.CIT;

public class CITItem
extends CIT {
    private static final String GENERATED_SUB_CITS_PREFIX = "sub_cititem_generated_";
    public static final Set<ResourceLocation> GENERATED_SUB_CITS_SEEN = new HashSet<ResourceLocation>();
    public Map<ResourceLocation, ResourceLocation> assetIdentifiers = new LinkedHashMap<ResourceLocation, ResourceLocation>();
    public Map<List<ItemOverride.Predicate>, BlockModel> unbakedAssets = new LinkedHashMap<List<ItemOverride.Predicate>, BlockModel>();
    private Map<String, Either<Material, String>> textureOverrideMap = new HashMap<String, Either<Material, String>>();
    private boolean isTexture = false;
    public BakedModel bakedModel = null;
    public CITOverrideList bakedSubModels = new CITOverrideList();
    public ResourceManager resourceManager;

    public CITItem(CITPack pack, ResourceLocation identifier, Properties properties) throws CITParseException {
        super(pack, identifier, properties);
        try {
            ResourceLocation assetIdentifier;
            if (this.items.size() == 0) {
                throw new Exception("CIT must target at least one item type");
            }
            boolean containsTexture = false;
            String modelProp = properties.getProperty("model");
            if (modelProp == null) {
                for (Object o : properties.keySet()) {
                    Object property;
                    if (!(o instanceof String) || !((String)(property = (String)o)).startsWith("texture") && !((String)property).startsWith("tile")) continue;
                    containsTexture = true;
                    break;
                }
            }
            if (!containsTexture) {
                assetIdentifier = CITItem.resolvePath1(identifier, modelProp, ".json", pack);
                if (assetIdentifier != null) {
                    this.assetIdentifiers.put(null, assetIdentifier);
                } else if (modelProp != null && (assetIdentifier = CITItem.resolvePath1(identifier, modelProp, ".json", pack)) != null) {
                    this.assetIdentifiers.put(null, assetIdentifier);
                }
            }
            for (Object o : properties.keySet()) {
                String property;
                if (!(o instanceof String) || !(property = (String)o).startsWith("model.")) continue;
                ResourceLocation subIdentifier = CITItem.resolvePath1(identifier, properties.getProperty(property), ".json", pack);
                if (subIdentifier == null) {
                    throw new Exception("Cannot resolve path for " + property);
                }
                String subItem = property.substring(6);
                ResourceLocation subItemIdentifier = this.fixDeprecatedSubItem(subItem);
                this.assetIdentifiers.put(subItemIdentifier == null ? new ResourceLocation("minecraft", "item/" + subItem) : subItemIdentifier, subIdentifier);
            }
            if (this.assetIdentifiers.size() == 0) {
                this.isTexture = true;
                textureProp = properties.getProperty("texture");
                if (textureProp == null) {
                    textureProp = properties.getProperty("tile");
                }
                if ((assetIdentifier = CITItem.resolvePath1(identifier, textureProp, ".png", pack)) != null) {
                    this.assetIdentifiers.put(null, assetIdentifier);
                }
                for (Object o : properties.keySet()) {
                    if (!(o instanceof String) || !(property = (String)o).startsWith("texture.")) continue;
                    subIdentifier = CITItem.resolvePath1(identifier, properties.getProperty(property), ".png", pack);
                    if (subIdentifier == null) {
                        throw new Exception("Cannot resolve path for " + property);
                    }
                    String subItem = property.substring(8);
                    ResourceLocation subItemIdentifier = this.fixDeprecatedSubItem(subItem);
                    this.assetIdentifiers.put(subItemIdentifier == null ? new ResourceLocation("minecraft", "item/" + subItem) : subItemIdentifier, subIdentifier);
                }
            } else {
                textureProp = properties.getProperty("texture");
                if (textureProp == null) {
                    textureProp = properties.getProperty("tile");
                }
                if (textureProp != null) {
                    assetIdentifier = CITItem.resolvePath1(identifier, textureProp, ".png", pack);
                    if (assetIdentifier != null) {
                        this.textureOverrideMap.put(null, (Either<Material, String>)Either.left((Object)new Material(TextureAtlas.f_118259_, (ResourceLocation)new ResewnItemModelIdentifier(assetIdentifier))));
                    } else {
                        throw new Exception("Cannot resolve path for texture");
                    }
                }
                for (Object o : properties.keySet()) {
                    if (!(o instanceof String) || !(property = (String)o).startsWith("texture.")) continue;
                    textureProp = properties.getProperty(property);
                    subIdentifier = CITItem.resolvePath1(identifier, textureProp, ".png", pack);
                    if (subIdentifier == null) {
                        throw new Exception("Cannot resolve path for " + property);
                    }
                    this.textureOverrideMap.put(property.substring(8), (Either<Material, String>)Either.left((Object)new Material(TextureAtlas.f_118259_, (ResourceLocation)new ResewnItemModelIdentifier(subIdentifier))));
                }
            }
            if (this.assetIdentifiers.size() == 0) {
                throw new Exception("Cannot resolve path for model/texture");
            }
        }
        catch (Exception e) {
            throw new CITParseException(pack.resourcePack, identifier, (String)(e.getClass() == Exception.class ? "" : e.getClass().getSimpleName() + ": ") + e.getMessage());
        }
    }

    public boolean containsResource(ResourceLocation identifier) {
        return this.resourceManager.m_213713_(identifier).isPresent();
    }

    public void loadUnbakedAssets(ResourceManager resourceManager) throws CITLoadException {
        try {
            if (this.isTexture) {
                ResourceLocation baseIdentifier;
                BlockModel itemJson = this.getModelForFirstItemType(resourceManager);
                if (itemJson.f_111417_.size() > 1) {
                    this.textureOverrideMap = itemJson.f_111417_;
                    ResourceLocation defaultAsset = this.assetIdentifiers.get(null);
                    this.textureOverrideMap.replaceAll((layerName, originalTextureEither) -> {
                        ResourceLocation textureIdentifier = this.assetIdentifiers.remove(originalTextureEither.map(Material::m_119203_, ResourceLocation::new));
                        if (textureIdentifier != null) {
                            return Either.left((Object)new Material(TextureAtlas.f_118259_, (ResourceLocation)new ResewnItemModelIdentifier(textureIdentifier)));
                        }
                        if (defaultAsset != null) {
                            return Either.left((Object)new Material(TextureAtlas.f_118259_, (ResourceLocation)new ResewnItemModelIdentifier(defaultAsset)));
                        }
                        return null;
                    });
                    if (this.assetIdentifiers.size() == 0 || this.assetIdentifiers.size() == 1 && this.assetIdentifiers.containsKey(null)) {
                        this.unbakedAssets.put(null, itemJson);
                        return;
                    }
                }
                if ((baseIdentifier = this.assetIdentifiers.remove(null)) != null) {
                    this.unbakedAssets.put(null, this.loadUnbakedAsset(resourceManager, baseIdentifier));
                }
                if (!this.assetIdentifiers.isEmpty()) {
                    LinkedHashMap overrideConditions = new LinkedHashMap();
                    for (Object item : this.items) {
                        ResourceLocation itemIdentifier = BuiltInRegistries.f_257033_.m_7981_(item);
                        overrideConditions.put(new ResourceLocation(itemIdentifier.m_135827_(), "item/" + itemIdentifier.m_135815_()), Collections.emptyList());
                        ResourceLocation itemModelIdentifier = new ResourceLocation(itemIdentifier.m_135827_(), "models/item/" + itemIdentifier.m_135815_() + ".json");
                        Resource itemModelResource = (Resource)resourceManager.m_213713_(itemModelIdentifier).get();
                        InputStreamReader resourceReader = new InputStreamReader(itemModelResource.m_215507_());
                        BlockModel itemModelJson = BlockModel.m_111461_((Reader)resourceReader);
                        if (itemModelJson.m_111484_().isEmpty()) continue;
                        for (ItemOverride override : itemModelJson.m_111484_()) {
                            overrideConditions.put(override.m_111718_(), override.m_173449_().toList());
                        }
                    }
                    ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                    Collections.reverse(overrideModels);
                    for (ResourceLocation overrideModel : overrideModels) {
                        ResourceLocation replacement = this.assetIdentifiers.remove(overrideModel);
                        if (replacement == null) continue;
                        List conditions = (List)overrideConditions.get(overrideModel);
                        this.unbakedAssets.put(conditions, this.loadUnbakedAsset(resourceManager, replacement));
                    }
                }
            } else {
                ResourceLocation baseIdentifier = this.assetIdentifiers.remove(null);
                if (baseIdentifier != null) {
                    if (!GENERATED_SUB_CITS_SEEN.add(baseIdentifier)) {
                        baseIdentifier = new ResourceLocation(baseIdentifier.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + baseIdentifier.m_135815_());
                    }
                    GENERATED_SUB_CITS_SEEN.add(baseIdentifier);
                    BlockModel model = this.loadUnbakedAsset(resourceManager, baseIdentifier);
                    this.unbakedAssets.put(null, model);
                    if (model.m_111484_().size() > 0 && this.textureOverrideMap.size() > 0) {
                        Object override2;
                        LinkedHashMap overrideConditions = new LinkedHashMap();
                        for (Object override2 : model.m_111484_()) {
                            overrideConditions.put(override2.m_111718_(), override2.m_173449_().toList());
                        }
                        ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                        Collections.reverse(overrideModels);
                        override2 = overrideModels.iterator();
                        while (override2.hasNext()) {
                            ResourceLocation overrideModel = (ResourceLocation)override2.next();
                            this.resourceManager = resourceManager;
                            ResourceLocation replacement = CITItem.resolvePath(baseIdentifier, overrideModel.toString(), ".json", resourceManager);
                            if (replacement == null) continue;
                            String subTexturePath = replacement.toString().substring(0, replacement.toString().lastIndexOf(46));
                            String subTextureName = subTexturePath.substring(subTexturePath.lastIndexOf(47) + 1);
                            replacement = baseIdentifier;
                            if (!GENERATED_SUB_CITS_SEEN.add(replacement)) {
                                replacement = new ResourceLocation(replacement.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_());
                            }
                            GENERATED_SUB_CITS_SEEN.add(replacement);
                            BlockModel jsonModel = this.loadUnbakedAsset(resourceManager, replacement);
                            jsonModel.m_111484_().clear();
                            jsonModel.f_111417_.replaceAll((layerName, texture) -> {
                                if (layerName != null) {
                                    try {
                                        for (String subTexture : this.textureOverrideMap.keySet()) {
                                            if (!subTextureName.equals(subTexture)) continue;
                                            return this.textureOverrideMap.get(subTexture);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return texture;
                            });
                            this.unbakedAssets.put((List)overrideConditions.get(overrideModel), jsonModel);
                        }
                    }
                }
                if (!this.assetIdentifiers.isEmpty()) {
                    LinkedHashMap overrideConditions = new LinkedHashMap();
                    for (Item item : this.items) {
                        ResourceLocation itemIdentifier = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                        overrideConditions.put(new ResourceLocation(itemIdentifier.m_135827_(), "item/" + itemIdentifier.m_135815_()), Collections.emptyList());
                        ResourceLocation itemModelIdentifier = new ResourceLocation(itemIdentifier.m_135827_(), "models/item/" + itemIdentifier.m_135815_() + ".json");
                        Resource itemModelResource = (Resource)resourceManager.m_213713_(itemModelIdentifier).get();
                        InputStreamReader resourceReader = new InputStreamReader(itemModelResource.m_215507_());
                        BlockModel itemModelJson = BlockModel.m_111461_((Reader)resourceReader);
                        if (itemModelJson.m_111484_().isEmpty()) continue;
                        for (ItemOverride override : itemModelJson.m_111484_()) {
                            overrideConditions.put(override.m_111718_(), override.m_173449_().toList());
                        }
                    }
                    ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                    Collections.reverse(overrideModels);
                    for (ResourceLocation overrideModel : overrideModels) {
                        ResourceLocation replacement = this.assetIdentifiers.remove(overrideModel);
                        if (replacement == null) continue;
                        if (!GENERATED_SUB_CITS_SEEN.add(replacement)) {
                            replacement = new ResourceLocation(replacement.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_());
                        }
                        GENERATED_SUB_CITS_SEEN.add(replacement);
                        List conditions = (List)overrideConditions.get(overrideModel);
                        this.unbakedAssets.put(conditions, this.loadUnbakedAsset(resourceManager, replacement));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CITLoadException(this.pack.resourcePack, this.propertiesIdentifier, (String)(e.getClass() == Exception.class ? "" : e.getClass().getSimpleName() + ": ") + e.getMessage());
        }
        finally {
            this.assetIdentifiers = null;
            this.textureOverrideMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockModel loadUnbakedAsset(ResourceManager resourceManager, ResourceLocation assetIdentifier) throws Exception {
        BlockModel json;
        ResourceLocation possibleIdentifier = assetIdentifier;
        while (possibleIdentifier.m_135815_().startsWith(GENERATED_SUB_CITS_PREFIX)) {
            possibleIdentifier = new ResourceLocation(possibleIdentifier.m_135827_(), possibleIdentifier.m_135815_().substring(possibleIdentifier.m_135815_().substring(GENERATED_SUB_CITS_PREFIX.length()).indexOf(95) + GENERATED_SUB_CITS_PREFIX.length() + 1));
        }
        ResourceLocation identifier = possibleIdentifier;
        if (identifier.m_135815_().endsWith(".json")) {
            BlockModel blockModel;
            InputStream is = null;
            try {
                ResourceLocation parentId;
                is = ((Resource)resourceManager.m_213713_(identifier).get()).m_215507_();
                json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                json.f_111416_ = assetIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                json.f_111417_.replaceAll((layer, original) -> {
                    Optional left = original.left();
                    if (left.isPresent()) {
                        this.resourceManager = resourceManager;
                        ResourceLocation resolvedIdentifier = CITItem.resolvePath(identifier, ((Material)left.get()).m_119203_().m_135815_(), ".png", resourceManager);
                        if (resolvedIdentifier != null) {
                            return Either.left((Object)new Material(((Material)left.get()).m_119193_(), (ResourceLocation)new ResewnItemModelIdentifier(resolvedIdentifier)));
                        }
                    }
                    return original;
                });
                if (this.textureOverrideMap.size() > 0) {
                    Either<Material, String> defaultTextureOverride;
                    Map jsonTextureMap = json.f_111417_;
                    if (jsonTextureMap.size() == 0) {
                        jsonTextureMap.put("layer0", null);
                    }
                    if ((defaultTextureOverride = this.textureOverrideMap.get(null)) != null) {
                        jsonTextureMap.replaceAll((layerName, spriteIdentifierStringEither) -> defaultTextureOverride);
                    }
                    jsonTextureMap.replaceAll((layerName, texture) -> {
                        if (layerName != null) {
                            try {
                                String[] split = ((String)texture.map(id -> id.m_119203_().m_135815_(), s -> s)).split("/");
                                String textureName = split[split.length - 1];
                                if (textureName.endsWith(".png")) {
                                    textureName = textureName.substring(0, textureName.length() - 4);
                                }
                                return Objects.requireNonNull(this.textureOverrideMap.get(textureName));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return texture;
                    });
                    jsonTextureMap.values().removeIf(Objects::isNull);
                }
                if ((parentId = json.getParentLocation()) != null) {
                    String[] parentIdPathSplit = parentId.m_135815_().split("/");
                    if ((parentId.m_135815_().startsWith("./") || parentIdPathSplit.length > 2 && parentIdPathSplit[1].equals("cit")) && (parentId = CITItem.resolvePath(identifier, parentId.m_135815_(), ".json", resourceManager)) != null) {
                        ((JsonUnbakedModelAccessor)json).setParentLocation(new ResewnItemModelIdentifier(parentId));
                    }
                }
                json.m_111484_().replaceAll(override -> {
                    ResourceLocation resolvedOverridePath;
                    String[] modelIdPathSplit = override.m_111718_().m_135815_().split("/");
                    if ((override.m_111718_().m_135815_().startsWith("./") || modelIdPathSplit.length > 2 && modelIdPathSplit[1].equals("cit")) && (resolvedOverridePath = CITItem.resolvePath(identifier, override.m_111718_().m_135815_(), ".json", resourceManager)) != null) {
                        return new ItemOverride((ResourceLocation)new ResewnItemModelIdentifier(resolvedOverridePath), override.m_173449_().collect(Collectors.toList()));
                    }
                    return override;
                });
                blockModel = json;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return blockModel;
        }
        if (identifier.m_135815_().endsWith(".png")) {
            json = this.getModelForFirstItemType(resourceManager);
            if (json == null) {
                json = new BlockModel(new ResourceLocation("minecraft", "item/generated"), new ArrayList(), (Map)ImmutableMap.of((Object)"layer0", (Object)Either.left((Object)new Material(TextureAtlas.f_118259_, (ResourceLocation)new ResewnItemModelIdentifier(identifier)))), Boolean.valueOf(true), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
            }
            json.m_111484_().clear();
            json.f_111416_ = identifier.toString();
            json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 4);
            json.f_111417_.replaceAll((layerName, originalTextureEither) -> {
                if (this.textureOverrideMap.size() > 0) {
                    Either<Material, String> textureOverride = this.textureOverrideMap.get(layerName);
                    if (textureOverride == null) {
                        textureOverride = this.textureOverrideMap.get(null);
                    }
                    return textureOverride == null ? originalTextureEither : textureOverride;
                }
                return Either.left((Object)new Material(TextureAtlas.f_118259_, identifier));
            });
            return json;
        }
        throw new Exception("Unknown asset type");
    }

    public ResourceLocation fixDeprecatedSubItem(String subItem) {
        String replacement;
        switch (subItem) {
            case "bow_pulling_standby": {
                String string = "bow";
                break;
            }
            case "crossbow_standby": {
                String string = "crossbow";
                break;
            }
            case "potion_bottle_drinkable": {
                String string = "potion";
                break;
            }
            case "potion_bottle_splash": {
                String string = "splash_potion";
                break;
            }
            case "potion_bottle_lingering": {
                String string = "lingering_potion";
                break;
            }
            default: {
                String string = replacement = null;
            }
        }
        if (replacement != null) {
            CITResewn.logWarnLoading("CIT Warning: Using deprecated sub item id \"" + subItem + "\" instead of \"" + replacement + "\" in " + this.pack.resourcePack.m_5542_() + " -> " + this.propertiesIdentifier.toString());
            return new ResourceLocation("minecraft", "item/" + replacement);
        }
        return null;
    }

    private BlockModel getModelForFirstItemType(ResourceManager resourceManager) {
        ResourceLocation firstItemIdentifier = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)this.items.iterator().next()));
        ResourceLocation firstItemModelIdentifier = new ResourceLocation(firstItemIdentifier.m_135827_(), "models/item/" + firstItemIdentifier.m_135815_() + ".json");
        try {
            BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)((Resource)resourceManager.m_213713_(firstItemModelIdentifier).get()).m_215507_(), (Charset)StandardCharsets.UTF_8));
            if (!GENERATED_SUB_CITS_SEEN.add(firstItemModelIdentifier)) {
                firstItemModelIdentifier = new ResourceLocation(firstItemModelIdentifier.m_135827_(), GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + firstItemModelIdentifier.m_135815_());
            }
            GENERATED_SUB_CITS_SEEN.add(firstItemModelIdentifier);
            json.f_111416_ = firstItemModelIdentifier.toString();
            json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    public BakedModel getItemModel(ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
        BakedModel bakedModel = this.bakedSubModels.m_173464_(this.bakedModel, stack, world, entity, seed);
        if (bakedModel != null && bakedModel.m_7343_() != null) {
            bakedModel = bakedModel.m_7343_().m_173464_(bakedModel, stack, world, entity, seed);
        }
        return bakedModel;
    }

    public static class CITOverrideList
    extends ItemOverrides {
        public void override(List<ItemOverride.Predicate> key, BakedModel bakedModel) {
            LinkedHashSet<ResourceLocation> conditionTypes = new LinkedHashSet<ResourceLocation>(Arrays.asList(this.f_173461_));
            for (ItemOverride.Predicate condition : key) {
                conditionTypes.add(condition.m_173459_());
            }
            this.f_173461_ = conditionTypes.toArray(new ResourceLocation[0]);
            this.f_111735_ = Arrays.copyOf(this.f_111735_, this.f_111735_.length + 1);
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            for (int i = 0; i < this.f_173461_.length; ++i) {
                object2IntMap.put((Object)this.f_173461_[i], i);
            }
            this.f_111735_[this.f_111735_.length - 1] = new ItemOverrides.BakedOverride((ItemOverrides.PropertyMatcher[])key.stream().map(arg_0 -> CITOverrideList.lambda$override$0((Object2IntMap)object2IntMap, arg_0)).toArray(ItemOverrides.PropertyMatcher[]::new), bakedModel);
        }

        private static /* synthetic */ ItemOverrides.PropertyMatcher lambda$override$0(Object2IntMap object2IntMap, ItemOverride.Predicate condition) {
            return new ItemOverrides.PropertyMatcher(object2IntMap.getInt((Object)condition.m_173459_()), condition.m_173460_());
        }
    }

    public static interface Cached {
        public CITItem citresewn_getCachedCITItem(Supplier<CITItem> var1);

        public boolean citresewn_isMojankCIT();

        public void citresewn_setMojankCIT(boolean var1);
    }
}

