/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.util.logic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Loops {
    public static <T> Map<T, Float> statelessFadingLoop(List<Map.Entry<T, Float>> items, float fade, int ticks, int tpu) {
        HashMap<T, Float> itemValues = new HashMap<T, Float>();
        if (items == null || items.size() == 0) {
            return itemValues;
        }
        if (items.size() == 1) {
            itemValues.put(items.get(0).getKey(), Float.valueOf(1.0f));
            return itemValues;
        }
        float totalUnitsInLoop = 0.0f;
        for (Map.Entry<T, Float> item : items) {
            itemValues.put(item.getKey(), Float.valueOf(0.0f));
            totalUnitsInLoop += item.getValue().floatValue() + fade;
        }
        float unitInLoop = (float)ticks % ((float)tpu * totalUnitsInLoop) / (float)tpu;
        for (int i = 0; i < items.size(); ++i) {
            Map.Entry<T, Float> item = items.get(i);
            if (unitInLoop < item.getValue().floatValue()) {
                itemValues.put(item.getKey(), Float.valueOf(1.0f));
                break;
            }
            if ((unitInLoop -= item.getValue().floatValue()) < fade) {
                Map.Entry<T, Float> nextItem = items.get(i + 1 >= items.size() ? 0 : i + 1);
                itemValues.put(item.getKey(), Float.valueOf(1.0f - (unitInLoop /= fade)));
                itemValues.put(nextItem.getKey(), Float.valueOf(unitInLoop));
                break;
            }
            unitInLoop -= fade;
        }
        return itemValues;
    }
}

