/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.snuffles.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import mod.schnappdragon.snuffles.common.entity.animal.Snuffle;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SnuffleModel<T extends Snuffle>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart hump;
    private final ModelPart tongue;
    private final ModelPart horns;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;

    public SnuffleModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.hump = this.body.m_171324_("hump");
        this.tongue = this.body.m_171324_("tongue");
        this.horns = this.body.m_171324_("horns");
        this.rightFrontLeg = part.m_171324_("right_front_leg");
        this.leftFrontLeg = part.m_171324_("left_front_leg");
        this.rightHindLeg = part.m_171324_("right_hind_leg");
        this.leftHindLeg = part.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        body.m_171599_("hump", CubeListBuilder.m_171558_().m_171514_(56, 30).m_171481_(-9.0f, -8.0f, -6.0f, 18.0f, 2.0f, 13.0f), PartPose.f_171404_);
        body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-9.0f, -6.0f, -10.0f, 18.0f, 11.0f, 20.0f), PartPose.f_171404_);
        body.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(80, 16).m_171481_(-6.0f, 0.0f, -7.0f, 12.0f, 1.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        body.m_171599_("fluff", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-9.0f, 5.0f, -10.0f, 18.0f, 5.0f, 20.0f), PartPose.f_171404_);
        PartDefinition horns = body.m_171599_("horns", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        horns.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(102, 0).m_171481_(-3.0f, -7.0f, -6.0f, 3.0f, 8.0f, 8.0f), PartPose.m_171423_((float)-9.0f, (float)-4.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        horns.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171481_(0.0f, -7.0f, -6.0f, 3.0f, 8.0f, 8.0f), PartPose.m_171423_((float)9.0f, (float)-4.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.m_171423_((float)-4.5f, (float)17.0f, (float)-5.5f, (float)0.0f, (float)0.0873f, (float)0.0f));
        partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.m_171423_((float)4.5f, (float)17.0f, (float)-5.5f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.m_171423_((float)-4.5f, (float)17.0f, (float)5.5f, (float)0.0f, (float)0.0873f, (float)0.0f));
        partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f), PartPose.m_171423_((float)4.5f, (float)17.0f, (float)5.5f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return Collections.emptyList();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindLeg, (Object)this.leftHindLeg);
    }

    public void prepareMobModel(Snuffle snuffle, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean flag;
        this.horns.f_104207_ = flag = !snuffle.m_6162_();
        this.hump.f_104207_ = flag;
    }

    public void setupAnim(Snuffle snuffle, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (snuffle.isFrosting()) {
            this.body.f_104203_ = -0.0436f + 0.2f * Mth.m_14031_((float)(ageInTicks * 1.2f));
            this.body.f_104205_ = 0.12f * Mth.m_14089_((float)(ageInTicks * 0.6f));
        } else {
            this.body.f_104203_ = -0.0436f + 0.2f * Mth.m_14031_((float)(limbSwing * 0.6f)) * limbSwingAmount;
            this.body.f_104205_ = 0.12f * Mth.m_14089_((float)(limbSwing * 0.2f)) * limbSwingAmount;
        }
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.45f)) * 1.5f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.45f + (float)Math.PI)) * 1.5f * limbSwingAmount;
        this.rightHindLeg.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.45f)) * 0.15f * limbSwingAmount;
        this.leftHindLeg.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.45f + (float)Math.PI)) * 0.15f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = this.leftHindLeg.f_104203_;
        this.leftFrontLeg.f_104203_ = this.rightHindLeg.f_104203_;
        this.rightFrontLeg.f_104205_ = this.rightHindLeg.f_104205_;
        this.leftFrontLeg.f_104205_ = this.leftHindLeg.f_104205_;
        this.tongue.f_104203_ = snuffle.isLicking() || snuffle.isFrosting() ? 0.3927f + Mth.m_14031_((float)(ageInTicks * 0.8f)) * 0.2f : 0.3927f + Mth.m_14031_((float)(ageInTicks * 0.12f)) * 0.2f;
    }
}

