/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.contraptions.components.actor;

import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.orcinus.overweightfarming.blocks.CropFullBlock;
import net.orcinus.overweightfarming.blocks.OverweightCocoaBlock;
import net.orcinus.overweightfarming.init.OFBlocks;
import plus.dragons.createcentralkitchen.content.contraptions.components.actor.HarvesterMovementBehaviourExtension;
import plus.dragons.createcentralkitchen.foundation.config.CentralKitchenConfigs;
import plus.dragons.createcentralkitchen.foundation.utility.ModLoadSubscriber;
import plus.dragons.createcentralkitchen.foundation.utility.Mods;

@ModLoadSubscriber(modid="overweight_farming")
public class OFHarvesterMovementBehaviorExtensions {
    private static final Map<Block, BlockState> FARMLAND_REVERT_MAP = new HashMap<Block, BlockState>();
    private static final String SNOWY_SPIRIT_MODID = "snowyspirit";
    private static final ResourceLocation GINGER = new ResourceLocation("snowyspirit", "ginger");

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FARMLAND_REVERT_MAP.put(Blocks.f_50440_, (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7)));
            FARMLAND_REVERT_MAP.put(Blocks.f_50493_, (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7)));
            if (ModList.get().isLoaded("farmersdelight")) {
                FARMLAND_REVERT_MAP.put((Block)ForgeRegistries.BLOCKS.getValue(Mods.fd("rich_soil")), ((Block)ForgeRegistries.BLOCKS.getValue(Mods.fd("rich_soil_farmland"))).m_49966_());
            }
            if (((Boolean)CentralKitchenConfigs.COMMON.integration.enableHarvesterSupportForOverweightFarming.get()).booleanValue()) {
                HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_BEETROOT.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, () -> ((Block)Blocks.f_50444_).m_49966_()));
                HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_CARROT.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, () -> ((Block)Blocks.f_50249_).m_49966_()));
                HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_POTATO.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, () -> ((Block)Blocks.f_50250_).m_49966_()));
                HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_NETHER_WART.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, () -> ((Block)Blocks.f_50200_).m_49966_()));
                HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_COCOA.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvestCocoa(behaviour, context, pos, state, replant));
                if (ModList.get().isLoaded("farmersdelight")) {
                    HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_CABBAGE.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, OFHarvesterMovementBehaviorExtensions.ofPlant(Mods.fd("cabbages"))));
                    HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_ONION.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, OFHarvesterMovementBehaviorExtensions.ofPlant(Mods.fd("onions"))));
                }
                if (ModList.get().isLoaded("bewitchment")) {
                    HarvesterMovementBehaviourExtension.REGISTRY.put((Block)OFBlocks.OVERWEIGHT_GINGER.get(), (behaviour, context, pos, state, replant, partial) -> OFHarvesterMovementBehaviorExtensions.harvest(behaviour, context, pos, state, replant, OFHarvesterMovementBehaviorExtensions.ofPlant(GINGER)));
                }
            }
        });
    }

    public static void harvest(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, Supplier<BlockState> plantSupplier) {
        if (!(state.m_60734_() instanceof CropFullBlock)) {
            return;
        }
        BlockState plant = plantSupplier.get();
        Level level = context.world;
        behaviour.dropItem(context, new ItemStack((ItemLike)state.m_60734_(), 1));
        if (replant) {
            Block block;
            if (FARMLAND_REVERT_MAP.containsKey(level.m_8055_(pos.m_7495_()).m_60734_())) {
                level.m_7731_(pos.m_7495_(), FARMLAND_REVERT_MAP.get(level.m_8055_(pos.m_7495_()).m_60734_()), 2);
            }
            if ((block = plant.m_60734_()) instanceof IPlantable) {
                IPlantable iPlantable = (IPlantable)block;
                if (!level.m_8055_(pos.m_7495_()).canSustainPlant((BlockGetter)level, pos, Direction.UP, iPlantable)) {
                    level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                    return;
                }
            }
            level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, plant, 2);
        }
    }

    public static void harvestCocoa(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant) {
        if (!(state.m_60734_() instanceof OverweightCocoaBlock)) {
            return;
        }
        Level level = context.world;
        BlockHelper.destroyBlock((Level)level, (BlockPos)pos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
        if (replant) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!level.m_8055_(pos.m_121945_(direction)).m_204336_(BlockTags.f_13111_)) continue;
                level.m_5594_(null, pos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)Blocks.f_50262_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction), 2);
                return;
            }
        }
    }

    private static Supplier<BlockState> ofPlant(final ResourceLocation id) {
        return new Supplier<BlockState>(){
            private Block block;

            @Override
            public BlockState get() {
                if (this.block == null) {
                    this.block = (Block)ForgeRegistries.BLOCKS.getValue(id);
                }
                return this.block.m_49966_();
            }
        };
    }
}

