/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.tag;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.FluidEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import plus.dragons.createcentralkitchen.foundation.data.tag.CckTagsProvider;

public class OptionalTags {
    @SafeVarargs
    public static <T extends Item, R extends AbstractRegistrate<R>> NonNullUnaryOperator<ItemBuilder<T, R>> item(TagKey<Item> ... tags) {
        return builder -> (ItemBuilder)builder.addMiscData(ProviderType.ITEM_TAGS, provIn -> {
            CckTagsProvider<Item> prov = new CckTagsProvider<Item>((RegistrateTagsProvider<Item>)provIn, (Function<Item, Holder.Reference<Item>>)((Function<Item, Holder.Reference>)Item::m_204114_));
            ResourceLocation name = new ResourceLocation(builder.getOwner().getModid(), builder.getName());
            for (TagKey tag : tags) {
                prov.tag((TagKey<Item>)tag).m_176839_(name);
            }
        });
    }

    public static <T extends Item, R extends AbstractRegistrate<R>> NonNullUnaryOperator<ItemBuilder<T, R>> item(ResourceLocation ... ids) {
        return builder -> (ItemBuilder)builder.addMiscData(ProviderType.ITEM_TAGS, provIn -> {
            CckTagsProvider<Item> prov = new CckTagsProvider<Item>((RegistrateTagsProvider<Item>)provIn, (Function<Item, Holder.Reference<Item>>)((Function<Item, Holder.Reference>)Item::m_204114_));
            ResourceLocation name = new ResourceLocation(builder.getOwner().getModid(), builder.getName());
            for (ResourceLocation id : ids) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)id);
                prov.tag((TagKey<Item>)tag).m_176839_(name);
            }
        });
    }

    @SafeVarargs
    public static <T extends Block, R extends AbstractRegistrate<R>> NonNullUnaryOperator<BlockBuilder<T, R>> block(TagKey<Block> ... tags) {
        return builder -> (BlockBuilder)builder.addMiscData(ProviderType.BLOCK_TAGS, provIn -> {
            CckTagsProvider<Block> prov = new CckTagsProvider<Block>((RegistrateTagsProvider<Block>)provIn, (Function<Block, Holder.Reference<Block>>)((Function<Block, Holder.Reference>)Block::m_204297_));
            ResourceLocation name = new ResourceLocation(builder.getOwner().getModid(), builder.getName());
            for (TagKey tag : tags) {
                prov.tag((TagKey<Block>)tag).m_176839_(name);
            }
        });
    }

    public static <T extends Block, R extends AbstractRegistrate<R>> NonNullUnaryOperator<BlockBuilder<T, R>> block(ResourceLocation ... ids) {
        return builder -> (BlockBuilder)builder.addMiscData(ProviderType.BLOCK_TAGS, provIn -> {
            CckTagsProvider<Block> prov = new CckTagsProvider<Block>((RegistrateTagsProvider<Block>)provIn, (Function<Block, Holder.Reference<Block>>)((Function<Block, Holder.Reference>)Block::m_204297_));
            ResourceLocation name = new ResourceLocation(builder.getOwner().getModid(), builder.getName());
            for (ResourceLocation id : ids) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id);
                prov.tag((TagKey<Block>)tag).m_176839_(name);
            }
        });
    }

    @SafeVarargs
    public static <T extends ForgeFlowingFluid, R extends AbstractRegistrate<R>> NonNullUnaryOperator<FluidBuilder<T, R>> fluid(TagKey<Fluid> ... tags) {
        return builder -> (FluidBuilder)builder.removeTag(tags).addMiscData(ProviderType.FLUID_TAGS, provIn -> {
            CckTagsProvider<Fluid> prov = new CckTagsProvider<Fluid>((RegistrateTagsProvider<Fluid>)provIn, (Function<Fluid, Holder.Reference<Fluid>>)((Function<Fluid, Holder.Reference>)Fluid::m_205069_));
            FluidEntry entry = (FluidEntry)builder.getOwner().get(builder.getName(), ForgeRegistries.Keys.FLUIDS);
            ResourceLocation flowing = entry.getId();
            ResourceLocation source = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)((ForgeFlowingFluid)entry.get()).m_5613_()));
            for (TagKey tag : tags) {
                prov.tag((TagKey<Fluid>)tag).m_176839_(flowing).m_176839_(source);
            }
        });
    }

    public static <T extends ForgeFlowingFluid, R extends AbstractRegistrate<R>> NonNullUnaryOperator<FluidBuilder<T, R>> fluid(ResourceLocation ... ids) {
        return builder -> (FluidBuilder)builder.tag(new TagKey[0]).addMiscData(ProviderType.FLUID_TAGS, provIn -> {
            CckTagsProvider<Fluid> prov = new CckTagsProvider<Fluid>((RegistrateTagsProvider<Fluid>)provIn, (Function<Fluid, Holder.Reference<Fluid>>)((Function<Fluid, Holder.Reference>)Fluid::m_205069_));
            FluidEntry entry = (FluidEntry)builder.getOwner().get(builder.getName(), ForgeRegistries.Keys.FLUIDS);
            ResourceLocation flowing = entry.getId();
            ResourceLocation source = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)((ForgeFlowingFluid)entry.get()).m_5613_()));
            for (ResourceLocation id : ids) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)id);
                prov.tag((TagKey<Fluid>)tag).m_176839_(flowing).m_176839_(source);
            }
        });
    }
}

