/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.item;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemHandlerModifiableView
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable inv;
    private final int start;
    private final int end;
    private final int size;

    public ItemHandlerModifiableView(IItemHandlerModifiable inv, int start, int end, int size) {
        this.inv = inv;
        this.start = start;
        this.end = end;
        this.size = size;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (slot < this.size) {
            int index = this.start + slot;
            if (index <= this.end) {
                this.inv.setStackInSlot(index, stack);
            }
        } else {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    public int getSlots() {
        return this.size;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.size) {
            int index = this.start + slot;
            if (index <= this.end) {
                return this.inv.getStackInSlot(index);
            }
            return ItemStack.f_41583_;
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot < this.size) {
            int index = this.start + slot;
            if (index <= this.end) {
                return this.inv.insertItem(index, stack, simulate);
            }
            return stack;
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.size) {
            int index = this.start + slot;
            if (index <= this.end) {
                return this.inv.extractItem(index, amount, simulate);
            }
            return ItemStack.f_41583_;
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
    }

    public int getSlotLimit(int slot) {
        if (slot < this.size) {
            int index = this.start + slot;
            if (index <= this.end) {
                return this.inv.getSlotLimit(index);
            }
            return 0;
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot < this.size) {
            int index = this.start + slot;
            return index <= this.end;
        }
        throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
    }
}

