/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.block;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlockEntity;
import io.github.mortuusars.sootychimneys.config.Config;
import io.github.mortuusars.sootychimneys.core.Smoke;
import io.github.mortuusars.sootychimneys.core.Wind;
import io.github.mortuusars.sootychimneys.core.WindGetter;
import io.github.mortuusars.sootychimneys.loot.ModLootTables;
import io.github.mortuusars.sootychimneys.recipe.SootScrapingRecipe;
import io.github.mortuusars.sootychimneys.recipe.ingredient.ChanceResult;
import io.github.mortuusars.sootychimneys.recipe.ingredient.ToolActionIngredient;
import io.github.mortuusars.sootychimneys.setup.ModBlockEntities;
import io.github.mortuusars.sootychimneys.setup.ModRecipeTypes;
import io.github.mortuusars.sootychimneys.setup.ModTags;
import io.github.mortuusars.sootychimneys.utils.RandomOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChimneyBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    public static final BooleanProperty BLOCKED = BooleanProperty.m_61465_((String)"blocked");
    public static final BooleanProperty STACKED = BooleanProperty.m_61465_((String)"stacked");
    protected final SootyChimneys.Chimney variant;
    protected final Type type;

    public ChimneyBlock(BlockBehaviour.Properties properties, SootyChimneys.Chimney variant, Type type) {
        super(properties);
        this.variant = variant;
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STACKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{BLOCKED}).m_61104_(new Property[]{STACKED});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)STACKED) != false ? this.variant.getStackedShape() : this.variant.getDefaultShape();
    }

    public SootyChimneys.Chimney getVariant() {
        return this.variant;
    }

    public Type getType() {
        return this.type;
    }

    public Smoke getSmokeProperties() {
        return this.variant.getSmoke();
    }

    public boolean isClean() {
        return this.type == Type.CLEAN;
    }

    public boolean isDirty() {
        return this.type == Type.DIRTY;
    }

    public boolean shouldEmitSmoke(BlockState blockState, Level level, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)LIT) != false && (Boolean)blockState.m_61143_((Property)BLOCKED) == false && (Boolean)blockState.m_61143_((Property)STACKED) == false && !level.m_8055_(pos.m_7494_()).m_204336_(ModTags.Blocks.SMOKE_BLOCKING);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult blockHitResult) {
        boolean newBlockedValue;
        if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return InteractionResult.PASS;
        }
        boolean bl = newBlockedValue = (Boolean)state.m_61143_((Property)BLOCKED) == false;
        if (level.f_46443_) {
            String messageTranslationKey = "message.sootychimneys." + (newBlockedValue ? "blocked" : "open");
            player.m_5661_((Component)Component.m_237115_((String)messageTranslationKey), true);
        } else {
            Vector3f particleOrigin = this.getSmokeProperties().getParticleOrigin();
            RandomSource random = level.m_213780_();
            for (int i = 0; i < random.m_188503_(5); ++i) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + particleOrigin.x()), (double)((float)pos.m_123342_() + particleOrigin.y()) - 0.1, (double)((float)pos.m_123343_() + particleOrigin.z()), 1, random.m_188583_() * 0.1, random.m_188583_() * 0.1, random.m_188583_() * 0.1, 0.0);
            }
            level.m_5594_(null, pos, newBlockedValue ? SoundEvents.f_12026_ : SoundEvents.f_12027_, SoundSource.BLOCKS, 0.8f, 0.85f + random.m_188501_() * 0.05f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(newBlockedValue)), 3);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        this.updateState(state, level, pos);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        this.updateState(state, level, pos);
    }

    protected void updateState(BlockState state, Level level, BlockPos pos) {
        ChimneyBlock chimney;
        Block block;
        boolean stacked = level.m_8055_(pos.m_7494_()).m_60734_() instanceof ChimneyBlock;
        if (stacked && (block = state.m_60734_()) instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isDirty()) {
            state = chimney.getVariant().getCleanBlock().m_49966_();
            chimney.spawnSootParticles(level, pos, true);
        }
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!level.m_276867_(pos)))).m_61124_((Property)STACKED, (Comparable)Boolean.valueOf(stacked)), 3);
    }

    public ParticleOptions getParticle(BlockState state, Level level, BlockPos pos) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        return stateBelow.m_60734_() instanceof ChimneyBlock && (Boolean)stateBelow.m_61143_((Property)STACKED) != false || stateBelow.m_204336_(ModTags.Blocks.SMOKE_BOOSTING) ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
    }

    public void emitParticle(Level level, double x, double y, double z, ParticleOptions particleType) {
        if (!level.f_46443_) {
            return;
        }
        RandomSource random = level.m_213780_();
        if (random.m_188501_() > this.getSmokeProperties().getIntensity()) {
            return;
        }
        Vector3f particleOffset = this.getSmokeProperties().getParticleOrigin();
        x += (double)particleOffset.x() - 0.5;
        y += (double)particleOffset.y() - 0.5;
        z += (double)particleOffset.z() - 0.5;
        Wind wind = WindGetter.getWind();
        double windStrengthModifier = (Double)Config.WIND_STRENGTH_MULTIPLIER.get();
        double xSpeed = wind.getXCoordinate() * (double)wind.getStrength() * windStrengthModifier;
        double zSpeed = wind.getYCoordinate() * (double)wind.getStrength() * windStrengthModifier;
        double ySpeed = 0.05 * (double)this.getSmokeProperties().getSpeed();
        Vector3f particleSpread = this.getSmokeProperties().getParticleSpread();
        int maxParticles = (int)(4.0f * Math.max(this.getSmokeProperties().getIntensity(), 0.5f));
        for (int i = 0; i < random.m_188503_(maxParticles); ++i) {
            level.m_6485_(particleType, true, RandomOffset.offset(x, particleSpread.x()), RandomOffset.offset(y, particleSpread.y()), RandomOffset.offset(z, particleSpread.z()), xSpeed, ySpeed, zSpeed);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ChimneyBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.m_5776_() && type == ModBlockEntities.CHIMNEY_BLOCK_ENTITY.get() ? ChimneyBlockEntity::particleTick : null;
    }

    public boolean m_6724_(BlockState blockState) {
        ChimneyBlock chimney;
        Block block = blockState.m_60734_();
        return block instanceof ChimneyBlock && (chimney = (ChimneyBlock)block).isClean();
    }

    public void m_213898_(BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        ChimneyBlock sootyChimney;
        Block block = blockState.m_60734_();
        if (block instanceof ChimneyBlock && (sootyChimney = (ChimneyBlock)block).isClean() && this.shouldEmitSmoke(blockState, (Level)level, pos) && random.m_188500_() < (Double)Config.DIRTY_CHANCE.get()) {
            level.m_7731_(pos, sootyChimney.getVariant().getDirtyBlock().m_49966_(), 3);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        ChimneyBlock sootyChimney;
        Block block = state.m_60734_();
        if (!(block instanceof ChimneyBlock) || !(sootyChimney = (ChimneyBlock)block).isDirty()) {
            return null;
        }
        Level level = context.m_43725_();
        Optional<Supplier<List<ItemStack>>> scrapingResult = this.getScrapingResult(state, level, context.m_43722_(), toolAction);
        if (scrapingResult.isEmpty()) {
            return null;
        }
        if (!simulate) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List<ItemStack> loot = scrapingResult.get().get();
                BlockPos pos = context.m_8083_();
                Vec3i faceNormal = context.m_43719_().m_122436_();
                Vector3f itemSpawnPosition = new Vector3f((float)pos.m_123341_() + 0.5f + (float)faceNormal.m_123341_() * 0.65f, (float)pos.m_123342_() + 0.6f + (float)faceNormal.m_123342_() * 0.65f, (float)pos.m_123343_() + 0.5f + (float)faceNormal.m_123343_() * 0.65f);
                this.spawnSootScrapingItems(itemSpawnPosition, serverLevel, loot);
            } else {
                sootyChimney.spawnSootParticles(level, context.m_8083_(), false);
            }
        }
        return sootyChimney.getVariant().getCleanBlock().m_152465_(state);
    }

    protected Optional<Supplier<List<ItemStack>>> getScrapingResult(BlockState state, Level level, ItemStack tool, ToolAction action) {
        Optional recipeOptional;
        block9: {
            block8: {
                if (((Boolean)Config.USE_LOOT_TABLES_FOR_SCRAPING.get()).booleanValue()) {
                    Optional<Supplier<List<ItemStack>>> optional;
                    if (action != ToolActions.AXE_SCRAPE || !tool.canPerformAction(ToolActions.AXE_SCRAPE)) {
                        return Optional.empty();
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        optional = Optional.of(() -> ModLootTables.getSootScrapingLootFor(state, serverLevel));
                    } else {
                        optional = Optional.of(Collections::emptyList);
                    }
                    return optional;
                }
                SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)state.m_60734_().m_5456_()), tool});
                recipeOptional = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.SOOT_SCRAPING.get(), (Container)simpleContainer, level);
                if (recipeOptional.isEmpty()) break block8;
                Ingredient ingredient = ((SootScrapingRecipe)recipeOptional.get()).getTool();
                if (!(ingredient instanceof ToolActionIngredient)) break block9;
                ToolActionIngredient toolActionIngredient = (ToolActionIngredient)ingredient;
                if (toolActionIngredient.toolAction.equals(action)) break block9;
            }
            return Optional.empty();
        }
        if (level.f_46443_) {
            return Optional.of(Collections::emptyList);
        }
        return Optional.of(() -> {
            SootScrapingRecipe recipe = (SootScrapingRecipe)recipeOptional.get();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ChanceResult result : recipe.getResults()) {
                ItemStack itemStack = result.rollOutput(level.m_213780_());
                if (itemStack.m_41619_()) continue;
                items.add(itemStack);
            }
            return items;
        });
    }

    public void spawnSootScrapingItems(Vector3f pos, ServerLevel level, List<ItemStack> items) {
        for (ItemStack itemStack : items) {
            ItemEntity entity = new ItemEntity((Level)level, (double)pos.x(), (double)pos.y(), (double)pos.z(), itemStack);
            entity.m_19983_(itemStack);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ChimneyBlock sootyChimney;
        Block block;
        boolean isDestroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (isDestroyed && (block = state.m_60734_()) instanceof ChimneyBlock && (sootyChimney = (ChimneyBlock)block).isDirty()) {
            sootyChimney.spawnSootParticles(level, pos, false);
        }
        return isDestroyed;
    }

    public void spawnSootParticles(Level level, BlockPos pos, boolean serverSide) {
        RandomSource random = level.m_213780_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < random.m_216339_(12, 20); ++i) {
            if (serverSide && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, RandomOffset.offset(x, 0.8f), RandomOffset.offset(y, 0.8f), RandomOffset.offset(z, 0.8f), 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, RandomOffset.offset(x, 0.8f), RandomOffset.offset(y, 0.8f), RandomOffset.offset(z, 0.8f), 0.0, 0.0, 0.0);
        }
    }

    public static enum Type {
        CLEAN,
        DIRTY;

    }
}

