/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.core;

import java.util.Objects;
import net.minecraft.util.Mth;

public class Wind {
    private double _angleDegrees;
    private float _strength;
    private double _xCoordinate;
    private double _yCoordinate;

    public Wind(double angleDegrees, float strength) {
        this._angleDegrees = angleDegrees;
        this._strength = strength;
    }

    public void set(double angleDegrees, float strength) {
        this._angleDegrees = angleDegrees;
        this._strength = strength;
        double _angleRadians = this.getAngleInRadians();
        this._xCoordinate = Math.cos(_angleRadians);
        this._yCoordinate = Math.sin(_angleRadians);
    }

    public void update(double addDegrees, float addStrength) {
        this._angleDegrees = (this._angleDegrees + addDegrees) % 360.0;
        this._strength = Mth.m_14036_((float)(this._strength + addStrength), (float)0.0f, (float)1.0f);
        double _angleRadians = this.getAngleInRadians();
        this._xCoordinate = Math.cos(_angleRadians);
        this._yCoordinate = Math.sin(_angleRadians);
    }

    public float getStrength() {
        return this._strength;
    }

    public double getAngleInDegrees() {
        return this._angleDegrees;
    }

    public double getAngleInRadians() {
        return this._angleDegrees * (Math.PI / 180);
    }

    public double getXCoordinate() {
        return this._xCoordinate;
    }

    public double getYCoordinate() {
        return this._yCoordinate;
    }

    public String toString() {
        return "Wind{Angle=" + String.format("%.1f", this._angleDegrees) + ", Strength=" + String.format("%.2f", Float.valueOf(this._strength)) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wind wind = (Wind)o;
        return this._angleDegrees == wind._angleDegrees && Float.compare(wind._strength, this._strength) == 0;
    }

    public int hashCode() {
        return Objects.hash(this._angleDegrees, Float.valueOf(this._strength));
    }
}

