/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.recipe.ingredient.ChanceResult;
import io.github.mortuusars.sootychimneys.setup.ModRecipeSerializers;
import io.github.mortuusars.sootychimneys.setup.ModRecipeTypes;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SootScrapingRecipe
implements Recipe<Container> {
    public static final int MAX_RESULTS = 3;
    private final ResourceLocation id;
    private final Ingredient chimney;
    private final Ingredient tool;
    private final NonNullList<ChanceResult> results;

    public SootScrapingRecipe(ResourceLocation id, Ingredient chimney, Ingredient tool, NonNullList<ChanceResult> results) {
        this.id = id;
        this.chimney = chimney;
        this.tool = tool;
        this.results = results;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getIngredientChimney() {
        return this.chimney;
    }

    public ItemStack getResultChimney() {
        for (ItemStack item : this.chimney.m_43908_()) {
            BlockItem blockItem;
            Item item2 = item.m_41720_();
            if (!(item2 instanceof BlockItem) || !((item2 = (blockItem = (BlockItem)item2).m_40614_()) instanceof ChimneyBlock)) continue;
            ChimneyBlock sootyChimney = (ChimneyBlock)item2;
            return new ItemStack((ItemLike)sootyChimney.getVariant().getCleanBlock().m_5456_());
        }
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.chimney);
        return nonnulllist;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public List<ChanceResult> getResults() {
        return this.results;
    }

    public boolean m_5818_(Container container, @NotNull Level level) {
        if (container.m_7983_()) {
            return false;
        }
        int itemsInContainer = 0;
        boolean chimneyMatched = false;
        boolean toolMatched = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_41619_()) {
                ++itemsInContainer;
            }
            if (this.chimney.test(stack)) {
                chimneyMatched = true;
                continue;
            }
            if (!this.tool.test(stack)) continue;
            toolMatched = true;
        }
        return itemsInContainer <= 2 && chimneyMatched && toolMatched;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess registryAccess) {
        return this.getResultChimney();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.getResultChimney();
    }

    protected int getMaxInputCount() {
        return 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SOOT_SCRAPING.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.SOOT_SCRAPING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SootScrapingRecipe> {
        @NotNull
        public SootScrapingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient chimney = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("chimney"));
            Ingredient tool = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("tool"));
            if (chimney.m_43947_()) {
                throw new JsonParseException("No 'chimney' is set for soot scraping recipe");
            }
            if (tool.m_43947_()) {
                throw new JsonParseException("No 'tool' is set for soot scraping recipe");
            }
            NonNullList results = NonNullList.m_122779_();
            JsonArray resultsJsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"results");
            for (JsonElement result : resultsJsonArray) {
                results.add((Object)ChanceResult.fromJson(result));
            }
            if (results.size() > 3) {
                throw new JsonParseException("Too many results for soot scraping recipe! The maximum quantity of unique results is 3");
            }
            return new SootScrapingRecipe(recipeId, chimney, tool, (NonNullList<ChanceResult>)results);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, SootScrapingRecipe recipe) {
            recipe.chimney.m_43923_(buffer);
            recipe.tool.m_43923_(buffer);
            buffer.m_130130_(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.toBuffer(buffer);
            }
        }

        @Nullable
        public SootScrapingRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            Ingredient chimney = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int resultsCount = buffer.m_130242_();
            NonNullList results = NonNullList.m_122780_((int)resultsCount, (Object)ChanceResult.EMPTY);
            results.replaceAll(ignored -> ChanceResult.fromBuffer(buffer));
            return new SootScrapingRecipe(recipeId, chimney, tool, (NonNullList<ChanceResult>)results);
        }
    }
}

