/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.gui;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.Validate;
import org.embeddedt.embeddium.gui.frame.tab.Tab;
import org.embeddedt.embeddium.render.ShaderModBridge;
import toni.sodiumoptionsapi.gui.AbstractFrame;
import toni.sodiumoptionsapi.gui.ScrollableFrame;
import toni.sodiumoptionsapi.gui.TabHeaderWidget;

public class SodiumOptionsTabFrame
extends org.embeddedt.embeddium.gui.frame.AbstractFrame {
    private static final int TAB_OPTION_INDENT = 5;
    private Dim2i tabSection;
    private final Dim2i frameSection;
    private final Multimap<String, Tab<?>> tabs;
    private final Runnable onSetTab;
    private final AtomicReference<Component> tabSectionSelectedTab;
    private final AtomicReference<Integer> tabSectionScrollBarOffset;
    private Tab<?> selectedTab;
    private String selectedHeader;
    private org.embeddedt.embeddium.gui.frame.AbstractFrame selectedFrame;
    private Dim2i tabSectionInner;
    private ScrollableFrame sidebarFrame;
    private FlatButtonWidget.Style style = SodiumOptionsTabFrame.getStyle();

    public SodiumOptionsTabFrame(Dim2i dim, boolean renderOutline, Multimap<String, Tab<?>> tabs, Runnable onSetTab, AtomicReference<Component> tabSectionSelectedTab, AtomicReference<Integer> tabSectionScrollBarOffset) {
        super(dim, renderOutline);
        this.tabs = ImmutableListMultimap.copyOf(tabs);
        Optional<Integer> result = Stream.concat(tabs.keys().stream().map(id -> this.getStringWidth((FormattedText)TabHeaderWidget.getLabel(id, true)) + 10), tabs.values().stream().map(tab -> this.getStringWidth((FormattedText)tab.title()) + 5)).max(Integer::compareTo);
        this.tabSection = new Dim2i(this.dim.x(), this.dim.y(), result.map(integer -> integer + 24).orElseGet(() -> (int)((double)this.dim.width() * 0.35)).intValue(), this.dim.height());
        this.frameSection = new Dim2i(this.tabSection.getLimitX(), this.dim.y(), this.dim.width() - this.tabSection.width(), this.dim.height());
        this.onSetTab = onSetTab;
        this.tabSectionSelectedTab = tabSectionSelectedTab;
        this.tabSectionScrollBarOffset = tabSectionScrollBarOffset;
        if (this.tabSectionSelectedTab.get() != null) {
            this.selectedTab = this.tabs.values().stream().filter(tab -> tab.title().getString().equals(this.tabSectionSelectedTab.get().getString())).findAny().orElse(null);
        }
        this.buildFrame();
        this.tabs.values().stream().filter(tab -> this.selectedTab != tab).forEach(tab -> tab.getFrameFunction().apply(this.frameSection));
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setHeader(String header, Tab<?> tab) {
        this.selectedHeader = header;
        this.setTab(tab);
    }

    public void setTab(Tab<?> tab) {
        Map map;
        Collection value;
        if (!(this.selectedHeader == null || (value = (Collection)(map = this.tabs.asMap()).getOrDefault(this.selectedHeader, null)) != null && value.contains(tab))) {
            this.selectedHeader = null;
        }
        this.selectedTab = tab;
        this.tabSectionSelectedTab.set(this.selectedTab.title());
        if (this.onSetTab != null) {
            this.onSetTab.run();
        }
        this.buildFrame();
    }

    public static FlatButtonWidget.Style getStyle() {
        FlatButtonWidget.Style style = new FlatButtonWidget.Style();
        style.bgHovered = -536870912;
        style.bgDefault = ColorARGB.pack((int)0, (int)0, (int)0, (int)85);
        style.bgDisabled = 0x60000000;
        style.textDefault = -1;
        style.textDisabled = -1862270977;
        return style;
    }

    public Dim2i withParentOffset(Dim2i ths, Dim2i parent) {
        return new Dim2i(parent.x() + ths.x(), parent.y() + ths.y(), ths.width(), ths.height());
    }

    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.selectedTab = (Tab)this.tabs.values().iterator().next();
        }
        int tabSectionY = 0;
        for (Map.Entry modEntry : this.tabs.asMap().entrySet()) {
            if (!(((String)modEntry.getKey()).equals("sodium") || ((String)modEntry.getKey()).equals("embeddium") || this.selectedHeader != null && this.selectedHeader.equals(modEntry.getKey()))) {
                tabSectionY += 22;
                continue;
            }
            if (this.selectedHeader != null && this.selectedHeader.equals(modEntry.getKey()) && ((Collection)modEntry.getValue()).size() == 1) continue;
            int size = ((Collection)modEntry.getValue()).size();
            if ((((String)modEntry.getKey()).equals("sodium") || ((String)modEntry.getKey()).equals("embeddium")) && ((Collection)modEntry.getValue()).stream().anyMatch(tab -> Objects.equals(tab.title().getString(), "Shader Packs..."))) {
                --size;
            }
            tabSectionY += 22 + size * 18;
        }
        this.tabSectionInner = tabSectionY > this.dim.height() ? new Dim2i(this.tabSection.x(), this.tabSection.y(), this.tabSection.width(), tabSectionY) : this.tabSection;
        this.sidebarFrame = ScrollableFrame.createBuilder().setDimension(this.tabSection).setFrame(new TabSidebarFrame(this.tabSectionInner)).setVerticalScrollBarOffset(this.tabSectionScrollBarOffset).build();
        this.children.add(this.sidebarFrame);
        this.rebuildTabFrame();
        super.buildFrame();
    }

    private void rebuildTabFrame() {
        if (this.selectedTab == null) {
            return;
        }
        org.embeddedt.embeddium.gui.frame.AbstractFrame frame = (org.embeddedt.embeddium.gui.frame.AbstractFrame)this.selectedTab.getFrameFunction().apply(this.frameSection);
        if (frame != null) {
            this.selectedFrame = frame;
            frame.buildFrame();
            this.children.add(frame);
        }
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        for (AbstractWidget widget : this.children) {
            if (widget == this.selectedFrame) continue;
            widget.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        if (this.selectedFrame != null) {
            this.selectedFrame.m_88315_(drawContext, mouseX, mouseY, delta);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.dim.containsCursor(mouseX, mouseY) && super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX) {
        return super.m_6050_(mouseX, mouseY, scrollX);
    }

    public static class Builder {
        private final Multimap<String, Tab<?>> functions = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        private Dim2i dim;
        private boolean renderOutline;
        private Runnable onSetTab;
        private AtomicReference<Component> tabSectionSelectedTab = new AtomicReference<Object>(null);
        private AtomicReference<Integer> tabSectionScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder addTabs(Consumer<Multimap<String, Tab<?>>> tabs) {
            tabs.accept(this.functions);
            return this;
        }

        public Builder onSetTab(Runnable onSetTab) {
            this.onSetTab = onSetTab;
            return this;
        }

        public Builder setTabSectionSelectedTab(AtomicReference<Component> tabSectionSelectedTab) {
            this.tabSectionSelectedTab = tabSectionSelectedTab;
            return this;
        }

        public Builder setTabSectionScrollBarOffset(AtomicReference<Integer> tabSectionScrollBarOffset) {
            this.tabSectionScrollBarOffset = tabSectionScrollBarOffset;
            return this;
        }

        public SodiumOptionsTabFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            return new SodiumOptionsTabFrame(this.dim, this.renderOutline, this.functions, this.onSetTab, this.tabSectionSelectedTab, this.tabSectionScrollBarOffset);
        }
    }

    class TabSidebarFrame
    extends AbstractFrame {
        TabSidebarFrame(Dim2i dim) {
            super(dim, false);
        }

        @Override
        public void buildFrame() {
            this.children.clear();
            this.drawable.clear();
            this.controlElements.clear();
            this.rebuildTabs();
            super.buildFrame();
        }

        private void rebuildTabs() {
            int offsetY = 0;
            int width = SodiumOptionsTabFrame.this.tabSection.width() - 4;
            int height = 18;
            for (Map.Entry modEntry : SodiumOptionsTabFrame.this.tabs.asMap().entrySet()) {
                int extraHeight = ((String)modEntry.getKey()).equals("sodium") || ((String)modEntry.getKey()).equals("embeddium") ? 0 : 4;
                Dim2i modHeaderDim = SodiumOptionsTabFrame.this.withParentOffset(new Dim2i(0, offsetY + extraHeight, width, height), SodiumOptionsTabFrame.this.tabSection);
                offsetY += height + extraHeight;
                Tab firstTab = ((Collection)modEntry.getValue()).stream().findFirst().orElse(null);
                TabHeaderWidget headerButton = new TabHeaderWidget(modHeaderDim, (String)modEntry.getKey(), () -> {
                    if (((String)modEntry.getKey()).equals("iris") || ((String)modEntry.getKey()).equals("oculus")) {
                        Object patt6828$temp = ShaderModBridge.openShaderScreen((Screen)Minecraft.m_91087_().f_91080_);
                        if (patt6828$temp instanceof Screen) {
                            Screen screen = (Screen)patt6828$temp;
                            Minecraft.m_91087_().m_91152_(screen);
                        }
                        return;
                    }
                    SodiumOptionsTabFrame.this.setHeader((String)modEntry.getKey(), firstTab);
                });
                headerButton.setLeftAligned(true);
                this.children.add(headerButton);
                if (!((String)modEntry.getKey()).equals("sodium") && !((String)modEntry.getKey()).equals("embeddium") && (SodiumOptionsTabFrame.this.selectedHeader == null || !SodiumOptionsTabFrame.this.selectedHeader.equals(modEntry.getKey()))) continue;
                if (((Collection)modEntry.getValue()).size() == 1) {
                    headerButton.setSelected(SodiumOptionsTabFrame.this.selectedTab == firstTab);
                    continue;
                }
                for (Tab tab : (Collection)modEntry.getValue()) {
                    if ((((String)modEntry.getKey()).equals("sodium") || ((String)modEntry.getKey()).equals("embeddium")) && Objects.equals(tab.title().getString(), "Shader Packs...")) continue;
                    Dim2i tabDim = SodiumOptionsTabFrame.this.withParentOffset(new Dim2i(0, offsetY, width, height), SodiumOptionsTabFrame.this.tabSection);
                    FlatButtonWidget button = new FlatButtonWidget(tabDim, tab.title(), () -> SodiumOptionsTabFrame.this.setTab(tab));
                    button.setStyle(SodiumOptionsTabFrame.this.style);
                    button.setSelected(SodiumOptionsTabFrame.this.selectedTab == tab);
                    button.setLeftAligned(true);
                    this.children.add(button);
                    offsetY += height;
                }
            }
        }
    }
}

