/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.util;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import toni.sodiumoptionsapi.api.OptionIdentifier;

public class OptionIdGenerator {
    private static final List<String> BLACKLISTED_PREFIXES = List.of("toni.sodiumoptionsapi", "net.caffeinemc.mods.sodium", "me.jellysquid.mods.sodium", "org.embeddedt.embeddium", "net.minecraft", "net.neoforged");
    private static final Map<Path, String> MOD_ID_FROM_URL_CACHE = new HashMap<Path, String>();

    private static boolean isAllowedClass(String name) {
        for (String prefix : BLACKLISTED_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private static Stream<Class<?>> streamFromName(String name) {
        try {
            return Stream.of(Class.forName(name));
        }
        catch (Throwable e) {
            return Stream.empty();
        }
    }

    public static <T> OptionIdentifier<T> generateId(String path) {
        Optional modId = StackWalker.getInstance().walk(frameStream -> frameStream.map(StackWalker.StackFrame::getClassName).filter(OptionIdGenerator::isAllowedClass).flatMap(OptionIdGenerator::streamFromName).map(clz -> {
            try {
                URL url;
                CodeSource source = clz.getProtectionDomain().getCodeSource();
                if (source != null && (url = source.getLocation()) != null) {
                    return MOD_ID_FROM_URL_CACHE.get(Paths.get(url.toURI()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull).findFirst());
        return modId.filter(id -> !id.equals("minecraft")).map(s -> OptionIdentifier.create(s, path)).orElse(null);
    }

    static {
        for (IModFileInfo info : ModList.get().getModFiles()) {
            Path rootPath;
            if (info.getMods().isEmpty()) continue;
            try {
                rootPath = info.getFile().findResource(new String[]{"/"});
            }
            catch (Throwable e) {
                continue;
            }
            MOD_ID_FROM_URL_CACHE.put(rootPath, ((IModInfo)info.getMods().get(0)).getModId());
        }
    }
}

