/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.capability.LodestoneWorldDataCapability;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class ListActiveWorldEventsCommand {
    private static final int whitespaceWidth = 20;
    private static final int ITEMS_PER_PAGE = 10;
    private static final int currentPage = 0;

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"all").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level);
            report.buildInteractiveMessage(component -> source.m_288197_(() -> component, true), 0);
            return 1;
        }))).then(Commands.m_82127_((String)"type").then(Commands.m_82129_((String)"worldEventType", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            WorldEventType worldEventType = WorldEventTypeArgument.getEventType(ctx, "worldEventType");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.m_81372_();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level, worldEventType);
            report.buildInteractiveMessage(component -> source.m_288197_(() -> component, true), 0);
            return 1;
        })))).then(Commands.m_82127_((String)"page").then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int page = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.m_81372_();
            ActiveWorldEventReport report = new ActiveWorldEventReport(level);
            report.buildInteractiveMessage(component -> source.m_288197_(() -> component, true), page);
            return 1;
        })));
    }

    protected static class ActiveWorldEventReport {
        private int instanceCount;
        private int frozenCount;
        private List<WorldEventInstance> activeWorldEvents;

        protected ActiveWorldEventReport(ServerLevel level) {
            LodestoneWorldDataCapability.getCapabilityOptional((Level)level).ifPresent(c -> {
                this.instanceCount = c.activeWorldEvents.size();
                this.frozenCount = (int)c.activeWorldEvents.stream().filter(WorldEventInstance::isFrozen).count();
                this.activeWorldEvents = c.activeWorldEvents;
            });
        }

        protected ActiveWorldEventReport(ServerLevel level, WorldEventType worldEventType) {
            LodestoneWorldDataCapability.getCapabilityOptional((Level)level).ifPresent(c -> {
                this.instanceCount = (int)c.activeWorldEvents.stream().filter(worldEventInstance -> worldEventInstance.type.equals(worldEventType)).count();
                this.frozenCount = (int)c.activeWorldEvents.stream().filter(worldEventInstance -> worldEventInstance.type.equals(worldEventType) && worldEventInstance.isFrozen()).count();
                this.activeWorldEvents = c.activeWorldEvents;
            });
        }

        private void buildInteractiveMessage(Consumer<Component> consumer, int page) {
            this.buildHeader(consumer);
            this.buildInteractiveIndexPage(consumer, page);
            this.buildInteractiveFooter(consumer, page);
        }

        private void buildInteractiveIndexPage(Consumer<Component> consumer, int page) {
            int startIndex = page * 10;
            int endIndex = Math.min(startIndex + 10, this.activeWorldEvents.size());
            for (int i = startIndex; i < endIndex; ++i) {
                WorldEventInstance event = this.activeWorldEvents.get(i);
                MutableComponent eventComponent = Component.m_237113_((String)String.format("%02d. | %s | ", i + 1, event.type.id.toString())).m_130948_(Style.f_131099_.m_131140_(i % 2 == 1 ? ChatFormatting.GRAY : ChatFormatting.WHITE).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)event.toString()))));
                MutableComponent detailsButton = Component.m_237113_((String)"[>]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent get " + event.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to see details"))));
                MutableComponent freezeButton = Component.m_237113_((String)"[F]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent freeze single " + event.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to freeze"))));
                MutableComponent unfreezeButton = Component.m_237113_((String)"[U]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent unfreeze single " + event.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to unfreeze"))));
                MutableComponent removeButton = Component.m_237113_((String)"[X]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent remove single " + event.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to remove"))));
                MutableComponent space = Component.m_237113_((String)"  ");
                consumer.accept((Component)eventComponent.m_7220_((Component)space).m_7220_((Component)detailsButton).m_7220_((Component)space).m_7220_((Component)(event.isFrozen() ? unfreezeButton : freezeButton)).m_7220_((Component)space).m_7220_((Component)removeButton));
            }
        }

        protected void buildInstanceDetailsPage(Consumer<Component> consumer, WorldEventInstance worldEventInstance) {
            MutableComponent worldEventDetailsHeader = Component.m_237113_((String)"World Event Details:").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true)));
            MutableComponent worldEventUUID = Component.m_237113_((String)"UUID: ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)worldEventInstance.uuid.toString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, worldEventInstance.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy")))));
            MutableComponent worldEventType = Component.m_237113_((String)"Type: ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)worldEventInstance.type.id.toString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list type " + worldEventInstance.type.id.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to filter by type")))));
            MutableComponent frozenStatus = Component.m_237113_((String)"Frozen: ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(worldEventInstance.isFrozen() ? "Yes" : "No")).m_130948_(Style.f_131099_.m_131140_(worldEventInstance.isFrozen() ? ChatFormatting.DARK_AQUA : ChatFormatting.GREEN)));
            MutableComponent worldEventData = Component.m_237113_((String)"Data:").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
            this.buildWhitespace(consumer);
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
            consumer.accept((Component)worldEventDetailsHeader);
            consumer.accept((Component)worldEventUUID);
            consumer.accept((Component)worldEventType);
            consumer.accept((Component)frozenStatus);
            consumer.accept((Component)ActiveWorldEventReport.getDashedSpaceLine().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
            consumer.accept((Component)worldEventData);
            this.buildDetailsBody(consumer, worldEventInstance.serializeNBT(new CompoundTag()));
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
            this.buildInteractiveFooter(consumer, worldEventInstance);
        }

        private void buildDetailsBody(Consumer<Component> consumer, CompoundTag tag) {
            tag.f_128329_.forEach((key, value) -> {
                if (key.equals("uuid") || key.equals("type") || key.equals("discarded") || key.equals("frozen")) {
                    return;
                }
                MutableComponent keyComponent = Component.m_237113_((String)(key + ": ")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
                MutableComponent valueComponent = Component.m_237113_((String)value.toString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
                consumer.accept((Component)keyComponent.m_7220_((Component)valueComponent));
            });
        }

        private void buildInteractiveFooter(Consumer<Component> consumer, WorldEventInstance instance) {
            MutableComponent backButton = Component.m_237113_((String)"[Back]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page 0")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Back to World Event List"))));
            MutableComponent freezeButton = Component.m_237113_((String)"[Freeze]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent freeze single " + instance.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Freeze this World Event"))));
            MutableComponent unfreezeButton = Component.m_237113_((String)"[Unfreeze]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent unfreeze single " + instance.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Unfreeze this World Event"))));
            MutableComponent removeButton = Component.m_237113_((String)"[Remove]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent remove single " + instance.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Remove this World Event"))));
            MutableComponent reloadButton = Component.m_237113_((String)"[Reload]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent get " + instance.uuid.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Reload this World Event"))));
            consumer.accept((Component)backButton.m_130946_("  ").m_7220_((Component)(instance.isFrozen() ? unfreezeButton : freezeButton)).m_130946_("  ").m_7220_((Component)removeButton).m_130946_("  ").m_7220_((Component)reloadButton));
        }

        private void buildHeader(Consumer<Component> consumer) {
            this.buildWhitespace(consumer);
            consumer.accept((Component)Component.m_237110_((String)"There are %s active World Events", (Object[])new Object[]{this.instanceCount}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
            consumer.accept((Component)Component.m_237110_((String)"%s events are frozen", (Object[])new Object[]{this.frozenCount}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)));
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        }

        private void buildInteractiveFooter(Consumer<Component> consumer, int page) {
            consumer.accept((Component)ActiveWorldEventReport.getDashedLine().m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
            MutableComponent previousPage = Component.m_237113_((String)"[<]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page " + (page - 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Previous Page"))));
            MutableComponent nextPage = Component.m_237113_((String)"[>]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page " + (page + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Next Page"))));
            MutableComponent removeAll = Component.m_237113_((String)"[Remove All]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent remove all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Remove all active World Events"))));
            MutableComponent freezeAll = Component.m_237113_((String)"[Freeze All]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent freeze all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Freeze all active World Events"))));
            MutableComponent unfreezeAll = Component.m_237113_((String)"[Unfreeze All]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent unfreeze all")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Unfreeze all active World Events"))));
            MutableComponent reload = Component.m_237113_((String)"[Reload]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lodestone worldevent list page " + page)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Reload active World Events"))));
            MutableComponent pageNumber = Component.m_237113_((String)String.valueOf(page)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
            MutableComponent navigation = previousPage.m_130946_("  ").m_7220_((Component)pageNumber).m_130946_("  ").m_7220_((Component)nextPage);
            MutableComponent freezeUnfreeze = this.frozenCount == this.instanceCount ? unfreezeAll : freezeAll;
            consumer.accept((Component)navigation.m_130946_("  ").m_7220_((Component)freezeUnfreeze).m_130946_("  ").m_7220_((Component)removeAll).m_130946_("  ").m_7220_((Component)reload));
        }

        private void buildWhitespace(Consumer<Component> consumer) {
            for (int i = 0; i < 20; ++i) {
                consumer.accept((Component)Component.m_237113_((String)" "));
            }
        }

        private static MutableComponent getDashedLine() {
            return Component.m_237113_((String)"-".repeat(40));
        }

        private static MutableComponent getDashedSpaceLine() {
            return Component.m_237113_((String)"- ".repeat(25));
        }
    }
}

