/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.capability.LodestoneWorldDataCapability;
import team.lodestar.lodestone.command.arguments.WorldEventInstanceArgument;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.network.worldevent.UpdateWorldEventPacket;
import team.lodestar.lodestone.registry.common.LodestonePacketRegistry;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class RemoveActiveWorldEventsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"all").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.m_81372_();
            AtomicInteger count = new AtomicInteger();
            LodestoneWorldDataCapability.getCapabilityOptional((Level)level).ifPresent(arg_0 -> RemoveActiveWorldEventsCommand.lambda$register$2(count, (Level)level, arg_0));
            if (count.get() > 0) {
                source.m_288197_(() -> Component.m_237110_((String)"command.lodestone.worldevent.remove.all.success", (Object[])new Object[]{String.valueOf(count.get())}), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237115_((String)"command.lodestone.worldevent.remove.all.fail"));
            return 0;
        }))).then(Commands.m_82127_((String)"single").then(Commands.m_82129_((String)"target", (ArgumentType)WorldEventInstanceArgument.worldEventInstance()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            WorldEventInstance event = WorldEventInstanceArgument.getEventInstance(ctx, "target");
            event.end((Level)source.m_81372_());
            LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateWorldEventPacket(event.uuid, event.synchronizeNBT()));
            source.m_288197_(() -> Component.m_237110_((String)"command.lodestone.worldevent.remove.target.success", (Object[])new Object[]{event.type.id.toString()}).m_130940_(ChatFormatting.AQUA), true);
            return 1;
        })))).then(Commands.m_82127_((String)"type").then(Commands.m_82129_((String)"type", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            WorldEventType type = WorldEventTypeArgument.getEventType(ctx, "type");
            AtomicInteger count = new AtomicInteger();
            LodestoneWorldDataCapability.getCapabilityOptional((Level)source.m_81372_()).ifPresent(c -> {
                List<WorldEventInstance> activeWorldEvents = c.activeWorldEvents.stream().filter(instance -> instance.type == type).toList();
                count.set(activeWorldEvents.size());
                activeWorldEvents.forEach(instance -> {
                    instance.end((Level)source.m_81372_());
                    LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateWorldEventPacket(instance.uuid, instance.synchronizeNBT()));
                });
            });
            if (count.get() > 0) {
                source.m_288197_(() -> Component.m_237110_((String)"command.lodestone.worldevent.remove.type.success", (Object[])new Object[]{String.valueOf(count.get()), type.id.toString()}).m_130940_(ChatFormatting.AQUA), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237110_((String)"command.lodestone.worldevent.remove.type.fail", (Object[])new Object[]{type.id.toString()}).m_130940_(ChatFormatting.RED));
            return 0;
        })));
    }

    private static /* synthetic */ void lambda$register$2(AtomicInteger count, Level level, LodestoneWorldDataCapability c) {
        count.set(c.activeWorldEvents.size());
        c.activeWorldEvents.forEach(instance -> {
            instance.end(level);
            LodestonePacketRegistry.LODESTONE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateWorldEventPacket(instance.uuid, instance.synchronizeNBT()));
        });
    }
}

