/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTHelper {
    public static CompoundTag filterTag(CompoundTag orig, TagFilter filter) {
        if (filter.filters.isEmpty()) {
            return orig;
        }
        CompoundTag copy = orig.m_6426_();
        NBTHelper.removeTags(copy, filter);
        return copy;
    }

    public static CompoundTag removeTags(CompoundTag tag, TagFilter filter) {
        CompoundTag newTag = new CompoundTag();
        for (String i : filter.filters) {
            if (tag.m_128441_(i)) {
                if (filter.isWhitelist) {
                    newTag.m_128365_(i, (Tag)newTag);
                    continue;
                }
                tag.m_128473_(i);
                continue;
            }
            for (String key : tag.m_128431_()) {
                Tag value = tag.m_128423_(key);
                if (!(value instanceof CompoundTag)) continue;
                CompoundTag ctag = (CompoundTag)value;
                NBTHelper.removeTags(ctag, filter);
            }
        }
        if (filter.isWhitelist) {
            tag = newTag;
        }
        return tag;
    }

    public static TagFilter create(String ... filters) {
        return new TagFilter(filters);
    }

    public static class TagFilter {
        public final ArrayList<String> filters = new ArrayList();
        public boolean isWhitelist;

        public TagFilter(String ... filters) {
            this.filters.addAll(List.of(filters));
        }

        public TagFilter setWhitelist() {
            this.isWhitelist = true;
            return this;
        }
    }
}

