/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class VecHelper {
    public static final Vec3 CENTER_OF_ORIGIN = new Vec3(0.5, 0.5, 0.5);

    public static Vec3 radialOffset(Vec3 pos, float distance, float current, float total) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle);
        double dz2 = (double)distance * Math.sin(angle);
        Vec3 vector = new Vec3(dx2, 0.0, dz2);
        double x = vector.f_82479_ * (double)distance;
        double z = vector.f_82481_ * (double)distance;
        return pos.m_82549_(new Vec3(x, 0.0, z));
    }

    public static ArrayList<Vec3> rotatingRadialOffsets(Vec3 pos, float distance, float total, float gameTime, float time) {
        return VecHelper.rotatingRadialOffsets(pos, distance, distance, total, gameTime, time);
    }

    public static ArrayList<Vec3> rotatingRadialOffsets(Vec3 pos, float distanceX, float distanceZ, float total, float gameTime, float time) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        int i = 0;
        while ((float)i < total) {
            positions.add(VecHelper.rotatingRadialOffset(pos, distanceX, distanceZ, i, total, gameTime, time));
            ++i;
        }
        return positions;
    }

    public static Vec3 rotatingRadialOffset(Vec3 pos, float distance, float current, float total, long gameTime, float time) {
        return VecHelper.rotatingRadialOffset(pos, distance, distance, current, total, gameTime, time);
    }

    public static Vec3 rotatingRadialOffset(Vec3 pos, float distanceX, float distanceZ, float current, float total, float gameTime, float time) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distanceX * Math.cos(angle += (double)(gameTime % time / time) * (Math.PI * 2));
        double dz2 = (double)distanceZ * Math.sin(angle);
        Vec3 vector2f = new Vec3(dx2, 0.0, dz2);
        double x = vector2f.f_82479_ * (double)distanceX;
        double z = vector2f.f_82481_ * (double)distanceZ;
        return pos.m_82520_(x, 0.0, z);
    }

    public static ArrayList<Vec3> blockOutlinePositions(Level level, BlockPos pos) {
        ArrayList<Vec3> arrayList = new ArrayList<Vec3>();
        double d0 = 0.5625;
        RandomSource random = level.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.m_188501_();
            arrayList.add(new Vec3((double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3));
        }
        return arrayList;
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return CENTER_OF_ORIGIN;
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }

    public static Vec3 axisAlignedPlaneOf(Vec3 vec) {
        vec = vec.m_82541_();
        return new Vec3(1.0, 1.0, 1.0).m_82492_(Math.abs(vec.f_82479_), Math.abs(vec.f_82480_), Math.abs(vec.f_82481_));
    }

    public static Vec3 rotate(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.m_14031_((float)angle);
        double cos = Mth.m_14089_((float)angle);
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vec3 projectToPlayerView(Vec3 target, float partialTicks) {
        Entity renderViewEntity;
        Camera ari = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 camera_pos = ari.m_90583_();
        Quaternionf camera_rotation_conj = new Quaternionf((Quaternionfc)ari.m_253121_());
        camera_rotation_conj.conjugate();
        Vector3f result3f = new Vector3f((float)(camera_pos.f_82479_ - target.f_82479_), (float)(camera_pos.f_82480_ - target.f_82480_), (float)(camera_pos.f_82481_ - target.f_82481_));
        result3f.rotate((Quaternionfc)camera_rotation_conj);
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue() && (renderViewEntity = mc.m_91288_()) instanceof Player) {
            Player player = (Player)renderViewEntity;
            float distwalked_modified = player.f_19787_;
            float f = distwalked_modified - player.f_19867_;
            float f1 = -(distwalked_modified + f * partialTicks);
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            Quaternionf q2 = new Quaternionf(new AxisAngle4f(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f, (Vector3fc)Vector3fHelper.XP));
            q2.conjugate();
            result3f.rotate((Quaternionfc)q2);
            Quaternionf q1 = new Quaternionf(new AxisAngle4f(Math.abs(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2) * 3.0f, (Vector3fc)Vector3fHelper.ZP));
            q1.conjugate();
            result3f.rotate((Quaternionfc)q1);
            Vector3f bob_translation = new Vector3f(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2), 0.0f);
            result3f.add((Vector3fc)new Vector3f(bob_translation.x(), -bob_translation.y(), bob_translation.z()));
        }
        float fov = (float)mc.f_91063_.m_109141_(ari, partialTicks, true);
        float half_height = (float)mc.m_91268_().m_85446_() / 2.0f;
        float scale_factor = half_height / (result3f.z() * (float)Math.tan(Math.toRadians(fov / 2.0f)));
        return new Vec3((double)(-result3f.x() * scale_factor), (double)(result3f.y() * scale_factor), (double)result3f.z());
    }

    public static class Vector3fHelper {
        public static Vector3f XP = new Vector3f(1.0f, 0.0f, 0.0f);
        public static Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
        public static Vector3f ZP = new Vector3f(0.0f, 0.0f, 1.0f);
        public static Vector3f XN = new Vector3f(-1.0f, 0.0f, 0.0f);
        public static Vector3f YN = new Vector3f(0.0f, -1.0f, 0.0f);
        public static Vector3f ZN = new Vector3f(0.0f, 0.0f, -1.0f);

        public static Quaternionf rotation(float rotation, Vector3f axis) {
            return new Quaternionf(new AxisAngle4f(rotation, (Vector3fc)axis));
        }
    }

    public static class Vector4fHelper {
        public static void perspectiveDivide(Vector4f v) {
            v.div(v.x, v.y, v.z, 1.0f);
        }
    }
}

