/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateHelper {
    public static BlockState getBlockStateWithExistingProperties(BlockState oldState, BlockState newState) {
        BlockState finalState = newState;
        for (Property property : oldState.m_61147_()) {
            if (!newState.m_61138_(property)) continue;
            finalState = BlockStateHelper.newStateWithOldProperty(oldState, finalState, property);
        }
        return finalState;
    }

    public static BlockState setBlockStateWithExistingProperties(Level level, BlockPos pos, BlockState newState, int flags) {
        BlockState oldState = level.m_8055_(pos);
        BlockState finalState = BlockStateHelper.getBlockStateWithExistingProperties(oldState, newState);
        level.m_7260_(pos, oldState, finalState, flags);
        level.m_7731_(pos, finalState, flags);
        return finalState;
    }

    public static <T extends Comparable<T>> BlockState newStateWithOldProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
    }

    public static void updateState(Level level, BlockPos pos) {
        BlockStateHelper.updateState(level.m_8055_(pos), level, pos);
    }

    public static void updateState(BlockState state, Level level, BlockPos pos) {
        level.m_7260_(pos, state, state, 2);
        level.m_151543_(pos);
    }

    public static void updateAndNotifyState(Level level, BlockPos pos) {
        BlockStateHelper.updateAndNotifyState(level.m_8055_(pos), level, pos);
    }

    public static void updateAndNotifyState(BlockState state, Level level, BlockPos pos) {
        BlockStateHelper.updateState(state, level, pos);
        state.m_60701_((LevelAccessor)level, pos, 2);
        level.m_46717_(pos, state.m_60734_());
    }
}

