/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.network.capability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import team.lodestar.lodestone.capability.LodestoneEntityDataCapability;
import team.lodestar.lodestone.systems.network.LodestoneTwoWayNBTPacket;
import team.lodestar.lodestone.systems.network.LodestoneTwoWayPacket;

public class SyncLodestoneEntityCapabilityPacket
extends LodestoneTwoWayNBTPacket {
    public static final String ENTITY_ID = "entity_id";
    private final int entityID;

    public SyncLodestoneEntityCapabilityPacket(CompoundTag tag) {
        super(tag);
        this.entityID = tag.m_128451_(ENTITY_ID);
    }

    public SyncLodestoneEntityCapabilityPacket(int id, CompoundTag tag) {
        super(SyncLodestoneEntityCapabilityPacket.handleTag(id, tag));
        this.entityID = id;
    }

    public static CompoundTag handleTag(int id, CompoundTag tag) {
        tag.m_128405_(ENTITY_ID, id);
        return tag;
    }

    @Override
    public void clientExecute(Supplier<NetworkEvent.Context> context, CompoundTag data) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
        LodestoneEntityDataCapability.getCapabilityOptional(entity).ifPresent(c -> c.deserializeNBT(data));
    }

    @Override
    public void serverExecute(Supplier<NetworkEvent.Context> context, CompoundTag data) {
        Entity entity = context.get().getSender().m_9236_().m_6815_(this.entityID);
        LodestoneEntityDataCapability.getCapabilityOptional(entity).ifPresent(c -> c.deserializeNBT(data));
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SyncLodestoneEntityCapabilityPacket.class, LodestoneTwoWayNBTPacket::encode, SyncLodestoneEntityCapabilityPacket::decode, LodestoneTwoWayPacket::handle);
    }

    public static SyncLodestoneEntityCapabilityPacket decode(FriendlyByteBuf buf) {
        return new SyncLodestoneEntityCapabilityPacket(buf.m_130260_());
    }
}

