/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.statesmith;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.AbstractBlockStateSmith;

public class ModularBlockStateSmith<T extends Block>
extends AbstractBlockStateSmith<T> {
    public final ModularSmithStateSupplier<T> stateSupplier;

    public ModularBlockStateSmith(Class<T> blockClass, ModularSmithStateSupplier<T> stateSupplier) {
        super(blockClass);
        this.stateSupplier = stateSupplier;
    }

    @SafeVarargs
    public final void act(AbstractBlockStateSmith.StateSmithData data, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Supplier<? extends Block> ... blocks) {
        this.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, actor, modelFileSupplier, blocks);
    }

    @SafeVarargs
    public final void act(AbstractBlockStateSmith.StateSmithData data, ItemModelSmith itemModelSmith, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            this.act(data, itemModelSmith, actor, modelFileSupplier, block);
        }
        List.of(blocks).forEach(data.consumer);
    }

    public void act(AbstractBlockStateSmith.StateSmithData data, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Collection<Supplier<? extends Block>> blocks) {
        this.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, actor, modelFileSupplier, blocks);
    }

    public void act(AbstractBlockStateSmith.StateSmithData data, ItemModelSmith itemModelSmith, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Collection<Supplier<? extends Block>> blocks) {
        blocks.forEach(r -> this.act(data, itemModelSmith, actor, modelFileSupplier, (Supplier<? extends Block>)r));
        new ArrayList<Supplier<? extends Block>>(blocks).forEach(data.consumer);
    }

    private void act(AbstractBlockStateSmith.StateSmithData data, ItemModelSmith itemModelSmith, AbstractBlockStateSmith.StateFunction<T> actor, ModelFileSupplier modelFileSupplier, Supplier<? extends Block> registryObject) {
        Block block = registryObject.get();
        if (this.blockClass.isInstance(block)) {
            this.stateSupplier.act((Block)this.blockClass.cast(block), data.provider, actor, modelFileSupplier);
            itemModelSmith.act(() -> ((Block)block).m_5456_(), data.provider.itemModelProvider);
        } else {
            LodestoneLib.LOGGER.warn("Block does not match the state smith it was assigned: " + ForgeRegistries.BLOCKS.getKey((Object)block));
        }
    }

    public static interface ModularSmithStateSupplier<T extends Block> {
        public void act(T var1, LodestoneBlockStateProvider var2, AbstractBlockStateSmith.StateFunction<T> var3, ModelFileSupplier var4);
    }

    public static interface ModelFileSupplier {
        public ModelFile generateModel(Block var1);
    }
}

