/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world.behaviors.components;

import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class SparkBehaviorComponent
implements LodestoneBehaviorComponent {
    protected final GenericParticleData lengthData;
    protected Vec3 cachedDirection;

    public SparkBehaviorComponent(GenericParticleData lengthData) {
        this.lengthData = lengthData;
    }

    public SparkBehaviorComponent() {
        this(null);
    }

    @Override
    public void tick(LodestoneWorldParticle particle) {
        Vec3 direction = particle.getParticleSpeed().m_82541_();
        if (!direction.equals((Object)Vec3.f_82478_)) {
            this.cachedDirection = direction;
        }
    }

    public GenericParticleData getLengthData(LodestoneWorldParticle particle) {
        return this.getLengthData() != null ? this.getLengthData() : particle.scaleData;
    }

    public Vec3 getDirection(LodestoneWorldParticle particle) {
        return this.getCachedDirection() != null ? this.getCachedDirection() : particle.getParticleSpeed().m_82541_();
    }

    @Override
    public LodestoneParticleBehavior getBehaviorType() {
        return LodestoneParticleBehavior.SPARK;
    }

    public GenericParticleData getLengthData() {
        return this.lengthData;
    }

    public Vec3 getCachedDirection() {
        return this.cachedDirection;
    }

    public Vec3 sparkStart(Vec3 pos, Vec3 offset) {
        return pos.m_82546_(offset);
    }

    public Vec3 sparkEnd(Vec3 pos, Vec3 offset) {
        return pos.m_82549_(offset);
    }
}

