/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.client.render.entity.DyedItemFrameRenderer;
import org.violetmoon.quark.content.tweaks.entity.DyedItemFrame;
import org.violetmoon.zeta.client.event.load.ZAddModels;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class DyeableItemFramesModule
extends ZetaModule {
    public static EntityType<DyedItemFrame> entityType;
    @Hint(key="item_frame_dyeing")
    List<Item> itemFrames = Arrays.asList(Items.f_42617_, Items.f_151063_);

    @LoadEvent
    public final void register(ZRegister event) {
        entityType = EntityType.Builder.m_20704_(DyedItemFrame::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(10).m_20717_(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new DyedItemFrame((EntityType<? extends DyedItemFrame>)entityType, (Level)world)).m_20712_("dyed_item_frame");
        event.getRegistry().register(entityType, "dyed_item_frame", Registries.f_256939_);
        Quark.ZETA.dyeables.register(Items.f_42617_, (ZetaModule)this);
        Quark.ZETA.dyeables.register(Items.f_151063_, (ZetaModule)this);
    }

    @PlayEvent
    public void onUse(ZRightClickBlock event) {
        InteractionHand hand;
        Player player = event.getPlayer();
        ItemStack stack = player.m_21120_(hand = event.getHand());
        if ((stack.m_150930_(Items.f_42617_) || stack.m_150930_(Items.f_151063_)) && Quark.ZETA.dyeables.isDyed(stack)) {
            InteractionResult result;
            BlockHitResult blockhit = event.getHitVec();
            UseOnContext context = new UseOnContext(player, hand, blockhit);
            Level level = player.m_9236_();
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            InteractionResult interactionResult = result = player.m_6047_() ? InteractionResult.PASS : state.m_60664_(level, player, hand, blockhit);
            if (result == InteractionResult.PASS) {
                result = this.useOn(context);
            }
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        }
    }

    private InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        if (player != null && !this.mayPlace(player, direction, itemstack, blockpos1)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        DyedItemFrame hangingentity = new DyedItemFrame(level, blockpos1, direction, Quark.ZETA.dyeables.getDye(itemstack), itemstack.m_150930_(Items.f_151063_));
        CompoundTag compoundtag = itemstack.m_41783_();
        if (compoundtag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)hangingentity, (CompoundTag)compoundtag);
        }
        if (hangingentity.m_7088_()) {
            if (!level.f_46443_) {
                hangingentity.m_7084_();
                level.m_220400_((Entity)player, GameEvent.f_157810_, hangingentity.m_20182_());
                level.m_7967_((Entity)hangingentity);
            }
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack stack, BlockPos pos) {
        return !player.m_9236_().m_151570_(pos) && player.m_36204_(pos, direction, stack);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends DyeableItemFramesModule {
        @LoadEvent
        public void registerAdditionalModels(ZAddModels event) {
            event.register((ResourceLocation)new ModelResourceLocation("quark", "extra/dyed_item_frame", "inventory"));
            event.register((ResourceLocation)new ModelResourceLocation("quark", "extra/dyed_item_frame_map", "inventory"));
        }

        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.m_174036_((EntityType)entityType, DyedItemFrameRenderer::new);
        }
    }
}

