/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZBabyEntitySpawn;
import org.violetmoon.zeta.event.play.entity.living.ZLivingTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tweaks")
public class PigLittersModule
extends ZetaModule {
    private static final String GOLDEN_CARROT_TAG = "quark:AteGoldenCarrot";
    @Config
    @Config.Min(value=1.0)
    public static int minPigLitterSize = 2;
    @Config
    @Config.Min(value=1.0)
    public static int maxPigLitterSize = 3;
    @Config
    public static boolean pigsEatGoldenCarrots = true;
    @Config
    @Config.Min(value=0.0)
    public static int minGoldenCarrotBoost = 0;
    @Config
    @Config.Min(value=0.0)
    public static int maxGoldenCarrotBoost = 2;

    public static boolean canEat(ItemStack stack) {
        return Quark.ZETA.modules.isEnabled(PigLittersModule.class) && pigsEatGoldenCarrots && stack.m_150930_(Items.f_42677_);
    }

    public static void onEat(Animal animal, ItemStack stack) {
        if (animal instanceof Pig && PigLittersModule.canEat(stack)) {
            animal.getPersistentData().m_128379_(GOLDEN_CARROT_TAG, true);
        }
    }

    private static int getNumberBetween(RandomSource random, int boundA, int boundB) {
        int min = Math.min(boundA, boundB);
        int max = Math.max(boundA, boundB);
        return min + random.m_188503_(max - min + 1);
    }

    @PlayEvent
    public void onPigAppear(ZEntityJoinLevel event) {
        Entity entity;
        if (pigsEatGoldenCarrots && (entity = event.getEntity()) instanceof Pig) {
            int priority;
            Pig pig = (Pig)entity;
            boolean alreadySetUp = pig.f_21345_.m_148105_().stream().anyMatch(goal -> {
                Goal patt2604$temp = goal.m_26015_();
                if (!(patt2604$temp instanceof TemptGoal)) return false;
                TemptGoal tempt = (TemptGoal)patt2604$temp;
                if (!tempt.f_25935_.test(new ItemStack((ItemLike)Items.f_42677_))) return false;
                return true;
            });
            if (!alreadySetUp && (priority = pig.f_21345_.m_148105_().stream().filter(goal -> goal.m_26015_() instanceof TemptGoal).findFirst().map(WrappedGoal::m_26012_).orElse(-1).intValue()) >= 0) {
                MiscUtil.addGoalJustAfterLatestWithPriority((GoalSelector)pig.f_21345_, (int)4, (Goal)new TemptGoal((PathfinderMob)pig, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_}), false));
            }
        }
    }

    @PlayEvent
    public void onEntityUpdate(ZLivingTick event) {
        Animal animal;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Animal && !(animal = (Animal)entity).m_27593_()) {
            animal.getPersistentData().m_128473_(GOLDEN_CARROT_TAG);
        }
    }

    @PlayEvent
    public void onPigBreed(ZBabyEntitySpawn.Lowest event) {
        Level lvl;
        AgeableMob mob = event.getChild();
        Mob mobA = event.getParentA();
        Mob mobB = event.getParentB();
        if (mob instanceof Pig && (lvl = mob.m_9236_()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)lvl;
            if (mobA instanceof Animal) {
                Animal parentA = (Animal)mobA;
                if (mobB instanceof Animal) {
                    Animal parentB = (Animal)mobB;
                    int litterSize = PigLittersModule.getNumberBetween(level.f_46441_, minPigLitterSize, maxPigLitterSize);
                    if (mobA.getPersistentData().m_128471_(GOLDEN_CARROT_TAG)) {
                        litterSize += PigLittersModule.getNumberBetween(level.f_46441_, minGoldenCarrotBoost, maxGoldenCarrotBoost);
                    }
                    if (mobB.getPersistentData().m_128471_(GOLDEN_CARROT_TAG)) {
                        litterSize += PigLittersModule.getNumberBetween(level.f_46441_, minGoldenCarrotBoost, maxGoldenCarrotBoost);
                    }
                    if (litterSize > 1) {
                        for (int i = 1; i < litterSize; ++i) {
                            AgeableMob newChild = parentA.m_142606_(level, (AgeableMob)parentB);
                            if (newChild == null) continue;
                            Player cause = event.getCausedByPlayer();
                            if (cause instanceof ServerPlayer) {
                                ServerPlayer player = (ServerPlayer)cause;
                                player.m_36220_(Stats.f_12937_);
                                CriteriaTriggers.f_10581_.m_147278_(player, parentA, parentB, newChild);
                            }
                            newChild.m_6863_(true);
                            newChild.m_7678_(parentA.m_20185_(), parentA.m_20186_(), parentA.m_20189_(), 0.0f, 0.0f);
                            level.m_47205_((Entity)newChild);
                        }
                    }
                }
            }
        }
    }
}

