/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;
import org.violetmoon.quark.content.world.config.BlossomTreeConfig;
import org.violetmoon.zeta.world.generator.Generator;

public class BlossomTreeGenerator
extends Generator {
    private final BlossomTreeConfig quarkConfig;
    private final ResourceKey<ConfiguredFeature<?, ?>> treeKey;

    public BlossomTreeGenerator(BlossomTreeConfig quarkConfig, ResourceKey<ConfiguredFeature<?, ?>> treeKey) {
        super(quarkConfig.dimensions);
        this.quarkConfig = quarkConfig;
        this.treeKey = treeKey;
    }

    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, RandomSource rand, BlockPos pos) {
        BlockState ground;
        BlockPos placePos = pos.m_7918_(rand.m_188503_(16), 0, rand.m_188503_(16));
        if (this.quarkConfig.biomeConfig.canSpawn(this.getBiome((LevelAccessor)worldIn, placePos, false)) && rand.m_188503_(this.quarkConfig.rarity) == 0 && (ground = worldIn.m_8055_(placePos = worldIn.m_5452_(Heightmap.Types.MOTION_BLOCKING, placePos).m_7495_())).m_60734_().canSustainPlant(ground, (BlockGetter)worldIn, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.f_50746_))) {
            BlockPos up = placePos.m_7494_();
            BlockState upState = worldIn.m_8055_(up);
            Registry cfgFeatureRegistry = worldIn.m_9598_().m_175515_(Registries.f_256911_);
            ConfiguredFeature cfgFeature = (ConfiguredFeature)cfgFeatureRegistry.m_6246_(this.treeKey);
            if (cfgFeature == null) {
                return;
            }
            ConfiguredFeature cool = cfgFeature;
            FeaturePlaceContext placeCtx = new FeaturePlaceContext(Optional.of(cool), (WorldGenLevel)worldIn, generator, rand, up, (FeatureConfiguration)((TreeConfiguration)cool.f_65378_()));
            if (upState.m_60722_((Fluid)Fluids.f_76193_)) {
                worldIn.m_7731_(up, Blocks.f_50016_.m_49966_(), 0);
            }
            Feature.f_65760_.m_142674_(placeCtx);
        }
    }
}

