/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.FusionBlockModel;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={BlockModel.class}, priority=900)
public class BlockModelMixin
implements BlockModelExtension {
    @Unique
    private ModelInstance<?> fusionModel;

    @ModifyVariable(method={"resolveParents(Ljava/util/function/Function;)V"}, at=@At(value="HEAD"), ordinal=0)
    private Function<ResourceLocation, UnbakedModel> adjustModelGetter(Function<ResourceLocation, UnbakedModel> modelGetter) {
        return location -> {
            UnbakedModel model = (UnbakedModel)modelGetter.apply((ResourceLocation)location);
            if (model instanceof FusionBlockModel) {
                return ((FusionBlockModel)model).hasVanillaModel() ? ((FusionBlockModel)model).getVanillaModel() : FusionBlockModel.DUMMY_MODEL;
            }
            return model;
        };
    }

    @Override
    public ModelInstance<?> getFusionModel() {
        return this.fusionModel;
    }

    @Override
    public void setFusionModel(ModelInstance<?> fusionModel) {
        this.fusionModel = fusionModel;
    }
}

