/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFUtils;

public class MathConstant
extends MathValue
implements MathComponent {
    public static final MathConstant ZERO_CONST = new MathConstant(0.0f);
    public static final MathConstant FALSE_CONST = new MathConstant(Float.NEGATIVE_INFINITY);
    private final float hardCodedValue;

    public MathConstant(float number, boolean isNegative) {
        this.hardCodedValue = isNegative ? -number : number;
    }

    public MathConstant(float number) {
        this.hardCodedValue = number;
    }

    @Override
    public MathValue.ResultSupplier getResultSupplier() {
        EMFUtils.logError("EMF math constant called supplier: this shouldn't happen!");
        return this::getResult;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public MathValue makeNegative() {
        return new MathConstant(-this.hardCodedValue);
    }

    public String toString() {
        return String.valueOf(this.getResult());
    }

    @Override
    public float getResult() {
        return this.hardCodedValue;
    }
}

