/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.emf;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;

public class KeyframeMethod
extends MathMethod {
    public KeyframeMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = KeyframeMethod.parseAllArgs(args, calculationInstance);
        MathComponent delta = parsedArgs.get(0);
        ArrayList<MathComponent> frames = new ArrayList<MathComponent>(parsedArgs.subList(1, parsedArgs.size()));
        MathComponent[] frameArray = frames.toArray(new MathComponent[0]);
        int frameEnd = frameArray.length - 1;
        MathValue.ResultSupplier supplier = () -> {
            float deltaRaw = delta.getResult();
            int deltaFloor = Mth.m_14143_((float)deltaRaw);
            if (deltaFloor >= frameEnd) {
                return frameArray[frameEnd].getResult();
            }
            if (deltaFloor <= 0) {
                return frameArray[0].getResult();
            }
            MathComponent baseFrame = frameArray[Mth.m_14045_((int)deltaFloor, (int)0, (int)frameEnd)];
            MathComponent beforeFrame = frameArray[Mth.m_14045_((int)(deltaFloor - 1), (int)0, (int)frameEnd)];
            MathComponent nextFrame = frameArray[Mth.m_14045_((int)(deltaFloor + 1), (int)0, (int)frameEnd)];
            MathComponent afterFrame = frameArray[Mth.m_14045_((int)(deltaFloor + 2), (int)0, (int)frameEnd)];
            float individualFrameDelta = Mth.m_14187_((float)deltaRaw);
            return Mth.m_216244_((float)individualFrameDelta, (float)beforeFrame.getResult(), (float)baseFrame.getResult(), (float)nextFrame.getResult(), (float)afterFrame.getResult());
        };
        if (delta.isConstant()) {
            float deltaRaw = delta.getResult();
            int deltaFloor = Mth.m_14143_((float)deltaRaw);
            if (deltaFloor >= frameEnd) {
                this.setOptimizedAlternativeToThis(frameArray[frameEnd]);
            } else if (deltaFloor <= 0) {
                this.setOptimizedAlternativeToThis(frameArray[0]);
            } else {
                MathComponent baseFrame = frameArray[Mth.m_14045_((int)deltaFloor, (int)0, (int)frameEnd)];
                MathComponent beforeFrame = frameArray[Mth.m_14045_((int)(deltaFloor - 1), (int)0, (int)frameEnd)];
                MathComponent nextFrame = frameArray[Mth.m_14045_((int)(deltaFloor + 1), (int)0, (int)frameEnd)];
                MathComponent afterFrame = frameArray[Mth.m_14045_((int)(deltaFloor + 2), (int)0, (int)frameEnd)];
                float individualFrameDelta = Mth.m_14187_((float)deltaRaw);
                this.setOptimizedAlternativeToThis(() -> Mth.m_216244_((float)individualFrameDelta, (float)beforeFrame.getResult(), (float)baseFrame.getResult(), (float)nextFrame.getResult(), (float)afterFrame.getResult()));
            }
        }
        this.setSupplierAndOptimize(supplier, parsedArgs);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3;
    }
}

