/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;

public class IfMethod
extends MathMethod {
    public IfMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = IfMethod.parseAllArgs(args, calculationInstance);
        if (parsedArgs.size() == 3) {
            MathComponent bool = parsedArgs.get(0);
            MathComponent tru = parsedArgs.get(1);
            MathComponent fals = parsedArgs.get(2);
            if (bool.isConstant()) {
                this.setOptimizedAlternativeToThis(MathValue.toBoolean(bool.getResult()) ? tru : fals);
            }
            this.setSupplierAndOptimize(() -> MathValue.toBoolean(bool.getResult()) ? tru.getResult() : fals.getResult(), parsedArgs);
        } else {
            ArrayList<Tuple> ifSets = new ArrayList<Tuple>();
            MathComponent lastElse = parsedArgs.get(parsedArgs.size() - 1);
            for (int i = 0; i < parsedArgs.size() - 1; i += 2) {
                MathComponent condition = parsedArgs.get(i);
                MathComponent result = parsedArgs.get(i + 1);
                if (!condition.isConstant()) {
                    MathValue.toBoolean(condition.getResult());
                    ifSets.add(new Tuple((Object)condition, (Object)result));
                    continue;
                }
                if (!MathValue.toBoolean(condition.getResult())) continue;
                lastElse = result;
                break;
            }
            if (ifSets.isEmpty()) {
                this.setOptimizedAlternativeToThis(lastElse);
            }
            MathComponent finalElse = lastElse;
            this.setSupplierAndOptimize(() -> {
                for (Tuple ifSet : ifSets) {
                    if (!MathValue.toBoolean(((MathComponent)ifSet.m_14418_()).getResult())) continue;
                    return ((MathComponent)ifSet.m_14419_()).getResult();
                }
                return finalElse.getResult();
            }, parsedArgs);
        }
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3 && argCount % 2 == 1;
    }
}

