/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.List;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.utils.EMFUtils;

public class PrintMethod
extends MathMethod {
    private int printCount = 0;

    public PrintMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        String id = args.get(0);
        MathComponent n = MathExpressionParser.getOptimizedExpression(args.get(1), false, calculationInstance);
        MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(2), false, calculationInstance);
        this.setSupplierAndOptimize(() -> {
            float xVal = x.getResult();
            if (this.getPrintCount() % (int)n.getResult() == 0 && !EMFManager.getInstance().isAnimationValidationPhase) {
                EMFUtils.log("print: [" + id + "] = " + xVal);
            }
            return xVal;
        });
    }

    private int getPrintCount() {
        ++this.printCount;
        return this.printCount;
    }

    @Override
    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 3;
    }
}

