/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.parts.EMFModelPartWithState;
import traben.entity_model_features.utils.EMFUtils;

@OnlyIn(value=Dist.CLIENT)
public class EMFModelPartVanilla
extends EMFModelPartWithState {
    final String name;
    final boolean isOptiFinePartSpecified;
    final Set<Integer> hideInTheseStates = new HashSet<Integer>();

    public EMFModelPartVanilla(String name, ModelPart vanillaPart, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> allVanillaParts) {
        super(new ArrayList<ModelPart.Cube>(), new HashMap<String, ModelPart>());
        this.name = name;
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log(" > EMF vanilla part made: " + name);
        }
        this.isOptiFinePartSpecified = optifinePartNames.contains(name);
        this.setFromState(this.getStateOf(vanillaPart));
        for (Map.Entry child : vanillaPart.f_104213_.entrySet()) {
            EMFModelPartVanilla vanilla = new EMFModelPartVanilla((String)child.getKey(), (ModelPart)child.getValue(), optifinePartNames, allVanillaParts);
            this.f_104213_.put((String)child.getKey(), vanilla);
            allVanillaParts.put((String)child.getKey(), vanilla);
        }
        this.vanillaChildren = this.f_104213_;
        this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
    }

    @Override
    protected float[] debugBoxColor() {
        return new float[]{0.0f, 1.0f, 0.0f};
    }

    @Override
    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.hideInTheseStates.contains(this.currentModelVariant)) {
            super.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    public void setHideInTheseStates(int variant) {
        this.hideInTheseStates.add(variant);
        this.f_104213_.values().forEach(part -> {
            if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)part);
                if (!vanilla.isOptiFinePartSpecified) {
                    vanilla.setHideInTheseStates(variant);
                }
            }
        });
    }

    public void receiveRootAnimationRunnable(int variant, Runnable run) {
        ((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(variant)).animation().setAnimation(run);
    }

    @Override
    public String toString() {
        return "[vanilla part " + this.name + "], cubes =" + this.f_104212_.size() + ", children = " + this.f_104213_.size();
    }

    @Override
    public String toStringShort() {
        return "[vanilla part " + this.name + "]";
    }
}

