/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client;

import fabric.net.mca.Config;
import fabric.net.mca.client.LanguageMap;
import fabric.net.mca.client.OnlineSpeechManager;
import fabric.net.mca.entity.CommonSpeechManager;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.Genetics;
import fabric.net.mca.util.LimitedLinkedHashMap;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7417;

public class SpeechManager {
    public static final SpeechManager INSTANCE = new SpeechManager();
    public static final int TOTAL_VOICES = 10;
    private final LimitedLinkedHashMap<UUID, class_1106> currentlyPlaying = new LimitedLinkedHashMap(10);
    private final class_5819 threadSafeRandom = class_5819.method_43050();

    public void onChatMessage(class_2561 message, UUID sender) {
        class_7417 content = message.method_10851();
        if (CommonSpeechManager.INSTANCE.translations.containsKey(content)) {
            this.speak((String)CommonSpeechManager.INSTANCE.translations.get(content), sender);
        } else {
            for (class_2561 sibling : message.method_10855()) {
                if (!CommonSpeechManager.INSTANCE.translations.containsKey(sibling.method_10851())) continue;
                this.speak((String)CommonSpeechManager.INSTANCE.translations.get(sibling.method_10851()), sender);
            }
        }
    }

    private VillagerEntityMCA getSpeaker(class_310 client, UUID sender) {
        if (client.field_1687 != null) {
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!(entity instanceof VillagerEntityMCA)) continue;
                VillagerEntityMCA v = (VillagerEntityMCA)entity;
                if (!entity.method_5667().equals(sender)) continue;
                return v;
            }
        }
        return null;
    }

    private void speak(String phrase, UUID sender) {
        VillagerEntityMCA villager;
        if (this.currentlyPlaying.containsKey(sender) && class_310.method_1551().method_1483().method_4877((class_1113)this.currentlyPlaying.get(sender))) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && (villager = this.getSpeaker(client, sender)) != null) {
            if (villager.isSpeechImpaired()) {
                return;
            }
            if (villager.isToYoungToSpeak()) {
                return;
            }
            float pitch = villager.method_6017();
            float gene = villager.getGenetics().getGene(Genetics.VOICE_TONE);
            String gender = villager.getGenetics().getGender().binary().getDataName();
            if (Config.getInstance().enableOnlineTTS) {
                String gameLang = client.field_1690.field_1883;
                if (LanguageMap.LANGUAGE_MAP.containsKey(gameLang) && !LanguageMap.LANGUAGE_MAP.get(gameLang).isEmpty()) {
                    String content = class_2477.method_10517().method_48307(phrase);
                    int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
                    String voice = gender + "_" + tone;
                    OnlineSpeechManager.INSTANCE.play(LanguageMap.LANGUAGE_MAP.get(gameLang), voice, pitch, content, (class_1297)villager);
                } else {
                    class_5250 styled = class_2561.method_43471((String)"command.tts_unsupported_language").method_27694(s -> s.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Luke100000/minecraft-comes-alive/wiki/TTS")));
                    client.field_1705.method_1743().method_1812((class_2561)styled);
                }
            } else {
                Collection keys;
                int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
                class_2960 sound = new class_2960("mca_voices", phrase.toLowerCase(Locale.ROOT) + "/" + gender + "_" + tone);
                if (client.field_1687 != null && client.field_1724 != null && (keys = client.method_1483().method_4864()).contains(sound)) {
                    class_1106 instance = new class_1106(class_3414.method_47908((class_2960)sound), class_3419.field_15254, 1.0f, pitch, (class_1297)villager, this.threadSafeRandom.method_43055());
                    this.currentlyPlaying.put(sender, instance);
                    client.method_1483().method_4873((class_1113)instance);
                }
            }
        }
    }
}

